/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.utilities.Utilities;

public class ChildKey
implements Comparable<ChildKey> {
    private final String key;
    private static final ChildKey MIN_KEY = new ChildKey("[MIN_KEY]");
    private static final ChildKey MAX_KEY = new ChildKey("[MAX_KEY]");
    private static final ChildKey PRIORITY_CHILD_KEY = new ChildKey(".priority");
    private static final ChildKey INFO_CHILD_KEY = new ChildKey(".info");

    public static ChildKey getMinName() {
        return MIN_KEY;
    }

    public static ChildKey getMaxName() {
        return MAX_KEY;
    }

    public static ChildKey getPriorityKey() {
        return PRIORITY_CHILD_KEY;
    }

    public static ChildKey getInfoKey() {
        return INFO_CHILD_KEY;
    }

    private ChildKey(String key) {
        this.key = key;
    }

    public String asString() {
        return this.key;
    }

    public boolean isPriorityChildName() {
        return this == PRIORITY_CHILD_KEY;
    }

    protected boolean isInt() {
        return false;
    }

    protected int intValue() {
        return 0;
    }

    @Override
    public int compareTo(ChildKey other) {
        if (this == other) {
            return 0;
        }
        if (this == MIN_KEY || other == MAX_KEY) {
            return -1;
        }
        if (other == MIN_KEY || this == MAX_KEY) {
            return 1;
        }
        if (this.isInt()) {
            if (other.isInt()) {
                int cmp = Utilities.compareInts(this.intValue(), other.intValue());
                return cmp == 0 ? Utilities.compareInts(this.key.length(), other.key.length()) : cmp;
            }
            return -1;
        }
        if (other.isInt()) {
            return 1;
        }
        return this.key.compareTo(other.key);
    }

    public String toString() {
        String string = this.key;
        return new StringBuilder(12 + String.valueOf(string).length()).append("ChildKey(\"").append(string).append("\")").toString();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChildKey)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ChildKey other = (ChildKey)obj;
        return this.key.equals(other.key);
    }

    public static ChildKey fromString(String key) {
        Integer intValue = Utilities.tryParseInt(key);
        if (intValue != null) {
            return new IntegerChildKey(key, intValue);
        }
        if (key.equals(".priority")) {
            return PRIORITY_CHILD_KEY;
        }
        assert (!key.contains("/"));
        return new ChildKey(key);
    }

    private static class IntegerChildKey
    extends ChildKey {
        private final int intValue;

        IntegerChildKey(String name, int intValue) {
            super(name);
            this.intValue = intValue;
        }

        @Override
        protected boolean isInt() {
            return true;
        }

        @Override
        protected int intValue() {
            return this.intValue;
        }

        @Override
        public String toString() {
            String string = ((ChildKey)this).key;
            return new StringBuilder(20 + String.valueOf(string).length()).append("IntegerChildName(\"").append(string).append("\")").toString();
        }
    }
}

