/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class JsonMapper {
    public static String serializeJson(Map<String, Object> object) throws IOException {
        return JsonMapper.serializeJsonValue(object);
    }

    public static String serializeJsonValue(Object object) throws IOException {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return JSONObject.quote((String)((String)object));
        }
        if (object instanceof Number) {
            try {
                return JSONObject.numberToString((Number)((Number)object));
            }
            catch (JSONException e) {
                throw new IOException("Could not serialize number", e);
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "true" : "false";
        }
        try {
            JSONStringer stringer = new JSONStringer();
            JsonMapper.serializeJsonValue(object, stringer);
            return stringer.toString();
        }
        catch (JSONException e) {
            throw new IOException("Failed to serialize JSON", e);
        }
    }

    private static void serializeJsonValue(Object object, JSONStringer stringer) throws IOException, JSONException {
        if (object instanceof Map) {
            stringer.object();
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                stringer.key((String)entry.getKey());
                JsonMapper.serializeJsonValue(entry.getValue(), stringer);
            }
            stringer.endObject();
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            stringer.array();
            for (Object entry : collection) {
                JsonMapper.serializeJsonValue(entry, stringer);
            }
            stringer.endArray();
        } else {
            stringer.value(object);
        }
    }

    public static Map<String, Object> parseJson(String json) throws IOException {
        try {
            return JsonMapper.unwrapJsonObject(new JSONObject(json));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public static Object parseJsonValue(String json) throws IOException {
        try {
            return JsonMapper.unwrapJson(new JSONTokener(json).nextValue());
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    private static Map<String, Object> unwrapJsonObject(JSONObject jsonObject) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>(jsonObject.length());
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, JsonMapper.unwrapJson(jsonObject.get(key)));
        }
        return map;
    }

    private static List<Object> unwrapJsonArray(JSONArray jsonArray) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(JsonMapper.unwrapJson(jsonArray.get(i)));
        }
        return list;
    }

    private static Object unwrapJson(Object o) throws JSONException {
        if (o instanceof JSONObject) {
            return JsonMapper.unwrapJsonObject((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return JsonMapper.unwrapJsonArray((JSONArray)o);
        }
        if (o.equals(JSONObject.NULL)) {
            return null;
        }
        return o;
    }
}

