/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.RuntimeExecutionException;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import com.google.firebase.tasks.TaskImpl;
import java.util.concurrent.Executor;

class ContinueWithCompletionListener<TResult, TContinuationResult>
implements TaskCompletionListener<TResult> {
    private final Executor mExecutor;
    private final Continuation<TResult, TContinuationResult> mContinuation;
    private final TaskImpl<TContinuationResult> mContinuationTask;

    public ContinueWithCompletionListener(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation, @NonNull TaskImpl<TContinuationResult> continuationTask) {
        this.mExecutor = executor;
        this.mContinuation = continuation;
        this.mContinuationTask = continuationTask;
    }

    @Override
    public void onComplete(final @NonNull Task<TResult> task) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = ContinueWithCompletionListener.this.mContinuation.then(task);
                }
                catch (RuntimeExecutionException e) {
                    if (e.getCause() instanceof Exception) {
                        ContinueWithCompletionListener.this.mContinuationTask.setException((Exception)e.getCause());
                    } else {
                        ContinueWithCompletionListener.this.mContinuationTask.setException(e);
                    }
                    return;
                }
                catch (Exception e) {
                    ContinueWithCompletionListener.this.mContinuationTask.setException(e);
                    return;
                }
                ContinueWithCompletionListener.this.mContinuationTask.setResult(result);
            }
        });
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException();
    }
}

