/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.OnFailureListener;
import com.google.firebase.tasks.OnSuccessListener;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskExecutors;
import com.google.firebase.tasks.TaskImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult result) {
        TaskImpl<TResult> task = new TaskImpl<TResult>();
        task.setResult(result);
        return task;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception e) {
        TaskImpl task = new TaskImpl();
        task.setException(e);
        return task;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.DEFAULT_THREAD_POOL, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, final @NonNull Callable<TResult> callable) {
        Preconditions.checkNotNull(executor, "Executor must not be null");
        Preconditions.checkNotNull(callable, "Callback must not be null");
        final TaskImpl task = new TaskImpl();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    task.setResult(callable.call());
                }
                catch (Exception e) {
                    task.setException(e);
                }
            }
        });
        return task;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        Preconditions.checkNotNull(task, "Task must not be null");
        if (task.isComplete()) {
            return Tasks.getResultOrThrowExecutionException(task);
        }
        AwaitListener listener = new AwaitListener();
        Tasks.addListener(task, listener);
        listener.await();
        return Tasks.getResultOrThrowExecutionException(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long timeout, @NonNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkNotNull(task, "Task must not be null");
        Preconditions.checkNotNull(unit, "TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.getResultOrThrowExecutionException(task);
        }
        AwaitListener listener = new AwaitListener();
        Tasks.addListener(task, listener);
        if (!listener.await(timeout, unit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.getResultOrThrowExecutionException(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> tasks) {
        if (tasks.isEmpty()) {
            return Tasks.forResult(null);
        }
        for (Task<?> task : tasks) {
            if (task != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        TaskImpl<Void> whenAllTask = new TaskImpl<Void>();
        WhenAllListener listener = new WhenAllListener(tasks.size(), whenAllTask);
        for (Task<?> task : tasks) {
            Tasks.addListener(task, listener);
        }
        return whenAllTask;
    }

    public static Task<Void> whenAll(Task<?> ... tasks) {
        if (tasks.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(tasks));
    }

    private static <TResult> TResult getResultOrThrowExecutionException(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void addListener(Task<?> task, CombinedListener listener) {
        task.addOnSuccessListener(TaskExecutors.DIRECT, listener);
        task.addOnFailureListener(TaskExecutors.DIRECT, listener);
    }

    private Tasks() {
    }

    private static final class WhenAllListener
    implements CombinedListener {
        private final Object mLock = new Object();
        private final int mNumTasks;
        private final TaskImpl<Void> mTask;
        @GuardedBy(value="mLock")
        private int mSuccessCounter;
        @GuardedBy(value="mLock")
        private int mFailuresCounter;
        @GuardedBy(value="mLock")
        private Exception mException;

        public WhenAllListener(int taskCount, TaskImpl<Void> task) {
            this.mNumTasks = taskCount;
            this.mTask = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(@NonNull Exception e) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mFailuresCounter;
                this.mException = e;
                this.checkForCompletionLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(Object o) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mSuccessCounter;
                this.checkForCompletionLocked();
            }
        }

        @GuardedBy(value="mLock")
        private void checkForCompletionLocked() {
            if (this.mSuccessCounter + this.mFailuresCounter == this.mNumTasks) {
                if (this.mException == null) {
                    this.mTask.setResult(null);
                } else {
                    int n = this.mFailuresCounter;
                    int n2 = this.mNumTasks;
                    this.mTask.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.mException));
                }
            }
        }
    }

    private static final class AwaitListener
    implements CombinedListener {
        private final CountDownLatch mLatch = new CountDownLatch(1);

        private AwaitListener() {
        }

        @Override
        public void onSuccess(Object o) {
            this.mLatch.countDown();
        }

        @Override
        public void onFailure(@NonNull Exception e) {
            this.mLatch.countDown();
        }

        public void await() throws InterruptedException {
            this.mLatch.await();
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.mLatch.await(timeout, unit);
        }
    }

    static interface CombinedListener
    extends OnSuccessListener<Object>,
    OnFailureListener {
    }
}

