/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.AggregationType;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

class ColumnTitle {
    private List<Value> values;
    public AggregationColumn aggregation;
    private boolean isMultiAggregationQuery;
    public static final String PIVOT_COLUMNS_SEPARATOR = ",";
    public static final String PIVOT_AGGREGATION_SEPARATOR = " ";

    public ColumnTitle(List<Value> list, AggregationColumn aggregationColumn, boolean bl) {
        this.values = list;
        this.aggregation = aggregationColumn;
        this.isMultiAggregationQuery = bl;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public ColumnDescription createColumnDescription(DataTable dataTable) {
        ColumnDescription columnDescription = dataTable.getColumnDescription(this.aggregation.getAggregatedColumn().getId());
        return this.createAggregationColumnDescription(columnDescription);
    }

    private String createIdPivotPrefix() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).append(PIVOT_AGGREGATION_SEPARATOR).toString();
    }

    private String createLabelPivotPart() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).toString();
    }

    private boolean isPivot() {
        return !this.values.isEmpty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColumnTitle)) {
            return false;
        }
        ColumnTitle columnTitle = (ColumnTitle)object;
        return ((Object)this.values).equals(columnTitle.values) && this.aggregation.equals(columnTitle.aggregation);
    }

    public int hashCode() {
        int n = 1279;
        n = n * 17 + ((Object)this.values).hashCode();
        n = n * 17 + this.aggregation.hashCode();
        return n;
    }

    ColumnDescription createAggregationColumnDescription(ColumnDescription columnDescription) {
        AggregationType aggregationType = this.aggregation.getAggregationType();
        String string = this.createIdPivotPrefix() + this.aggregation.getId();
        ValueType valueType = columnDescription.getType();
        String string2 = this.aggregation.getAggregationType().getCode() + PIVOT_AGGREGATION_SEPARATOR + columnDescription.getLabel();
        String string3 = this.createLabelPivotPart();
        String string4 = this.isPivot() ? (this.isMultiAggregationQuery ? string3 + PIVOT_AGGREGATION_SEPARATOR + string2 : string3) : string2;
        ColumnDescription columnDescription2 = this.canUseSameTypeForAggregation(valueType, aggregationType) ? new ColumnDescription(string, valueType, string4) : new ColumnDescription(string, ValueType.NUMBER, string4);
        return columnDescription2;
    }

    private boolean canUseSameTypeForAggregation(ValueType valueType, AggregationType aggregationType) {
        boolean bl;
        if (valueType == ValueType.NUMBER) {
            bl = true;
        } else {
            switch (aggregationType) {
                case MIN: 
                case MAX: {
                    bl = true;
                    break;
                }
                case SUM: 
                case AVG: 
                case COUNT: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return bl;
    }
}

