/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.List;

public class Lower
implements ScalarFunction {
    private static final String FUNCTION_NAME = "lower";
    private static final Lower INSTANCE = new Lower();

    private Lower() {
    }

    public static Lower getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> list) {
        return new TextValue(((TextValue)list.get(0)).getValue().toLowerCase());
    }

    @Override
    public ValueType getReturnType(List<ValueType> list) {
        return ValueType.TEXT;
    }

    @Override
    public void validateParameters(List<ValueType> list) throws InvalidQueryException {
        if (list.size() != 1) {
            throw new InvalidQueryException("lower requires 1 parmaeter");
        }
        if (list.get(0) != ValueType.TEXT) {
            throw new InvalidQueryException("lower takes a text parameter");
        }
    }

    @Override
    public String toQueryString(List<String> list) {
        return "lower(" + list.get(0) + ")";
    }
}

