/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import org.apache.commons.lang.StringEscapeUtils;

public class EscapeUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private EscapeUtil() {
    }

    public static String jsonEscape(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block14: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuffer.append("\\u0027");
                    continue block14;
                }
                case '\"': {
                    stringBuffer.append("\\u0022");
                    continue block14;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block14;
                }
                case '<': {
                    stringBuffer.append("\\u003c");
                    continue block14;
                }
                case '>': {
                    stringBuffer.append("\\u003e");
                    continue block14;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        stringBuffer.append('\\');
                        switch (c) {
                            case '\b': {
                                stringBuffer.append('b');
                                continue block14;
                            }
                            case '\t': {
                                stringBuffer.append('t');
                                continue block14;
                            }
                            case '\n': {
                                stringBuffer.append('n');
                                continue block14;
                            }
                            case '\f': {
                                stringBuffer.append('f');
                                continue block14;
                            }
                            case '\r': {
                                stringBuffer.append('r');
                                continue block14;
                            }
                        }
                        stringBuffer.append('u');
                        stringBuffer.append(HEX_DIGITS[c >> 12 & 0xF]);
                        stringBuffer.append(HEX_DIGITS[c >> 8 & 0xF]);
                        stringBuffer.append(HEX_DIGITS[c >> 4 & 0xF]);
                        stringBuffer.append(HEX_DIGITS[c & 0xF]);
                        continue block14;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String htmlEscape(String string) {
        return StringEscapeUtils.escapeHtml((String)string);
    }
}

