/*
 * Decompiled with CFR 0.152.
 */
package com.guichaguri.minimalftp;

import com.guichaguri.minimalftp.FTPConnection;
import com.guichaguri.minimalftp.Utils;
import com.guichaguri.minimalftp.api.IFTPListener;
import com.guichaguri.minimalftp.api.IUserAuthenticator;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;

public class FTPServer
implements Closeable {
    protected final List<FTPConnection> connections = Collections.synchronizedList(new ArrayList());
    protected final List<IFTPListener> listeners = Collections.synchronizedList(new ArrayList());
    protected IUserAuthenticator auth = null;
    protected int idleTimeout = 300000;
    protected int bufferSize = 1024;
    protected SSLContext ssl = null;
    protected boolean explicitSecurity = true;
    protected ServerSocket socket = null;
    protected ServerThread serverThread = null;

    public FTPServer() {
    }

    public FTPServer(IUserAuthenticator auth) {
        this.setAuthenticator(auth);
    }

    public InetAddress getAddress() {
        return this.socket != null ? this.socket.getInetAddress() : null;
    }

    public int getPort() {
        return this.socket != null ? this.socket.getLocalPort() : -1;
    }

    public IUserAuthenticator getAuthenticator() {
        return this.auth;
    }

    public void setAuthenticator(IUserAuthenticator auth) {
        if (auth == null) {
            throw new NullPointerException("The Authenticator is null");
        }
        this.auth = auth;
    }

    public SSLContext getSSLContext() {
        return this.ssl;
    }

    public void setSSLContext(SSLContext ssl) {
        this.ssl = ssl;
    }

    public void setExplicitSSL(boolean explicit) {
        this.explicitSecurity = explicit;
    }

    public void setTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IFTPListener listener) {
        List<IFTPListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IFTPListener listener) {
        List<IFTPListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void listen(int port) throws IOException {
        this.listen(null, port);
    }

    public void listen(InetAddress address, int port) throws IOException {
        if (this.auth == null) {
            throw new NullPointerException("The Authenticator is null");
        }
        if (this.socket != null) {
            throw new IOException("Server already started");
        }
        this.socket = Utils.createServer(port, 50, address, this.ssl, !this.explicitSecurity);
        this.serverThread = new ServerThread();
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    public void listenSync(int port) throws IOException {
        this.listenSync(null, port);
    }

    public void listenSync(InetAddress address, int port) throws IOException {
        if (this.auth == null) {
            throw new NullPointerException("The Authenticator is null");
        }
        if (this.socket != null) {
            throw new IOException("Server already started");
        }
        this.socket = Utils.createServer(port, 50, address, this.ssl, !this.explicitSecurity);
        while (!this.socket.isClosed()) {
            this.update();
        }
    }

    protected void update() {
        try {
            this.addConnection(this.socket.accept());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected FTPConnection createConnection(Socket socket) throws IOException {
        return new FTPConnection(this, socket, this.idleTimeout, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(Socket socket) throws IOException {
        FTPConnection con = this.createConnection(socket);
        List<Object> list = this.listeners;
        synchronized (list) {
            for (IFTPListener l : this.listeners) {
                l.onConnected(con);
            }
        }
        list = this.connections;
        synchronized (list) {
            this.connections.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(FTPConnection con) throws IOException {
        List<Object> list = this.listeners;
        synchronized (list) {
            for (IFTPListener l : this.listeners) {
                l.onDisconnected(con);
            }
        }
        list = this.connections;
        synchronized (list) {
            this.connections.remove(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        if (this.serverThread != null) {
            this.serverThread.interrupt();
            this.serverThread = null;
        }
        List<FTPConnection> list = this.connections;
        synchronized (list) {
            for (FTPConnection con : this.connections) {
                try {
                    con.stop(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.connections.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.dispose();
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    private class ServerThread
    extends Thread {
        private ServerThread() {
        }

        @Override
        public void run() {
            while (FTPServer.this.socket != null && !FTPServer.this.socket.isClosed()) {
                FTPServer.this.update();
            }
        }
    }
}

