/*
 * Decompiled with CFR 0.152.
 */
package com.guichaguri.minimalftp;

import com.guichaguri.minimalftp.api.IFileSystem;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.net.ssl.SSLContext;

public class Utils {
    public static final int CAT_OWNER = 6;
    public static final int CAT_GROUP = 3;
    public static final int CAT_PUBLIC = 0;
    public static final int TYPE_READ = 2;
    public static final int TYPE_WRITE = 1;
    public static final int TYPE_EXECUTE = 0;
    private static final SimpleDateFormat mdtmFormat = new SimpleDateFormat("YYYYMMddHHmmss", Locale.ENGLISH);
    private static final SimpleDateFormat hourFormat = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    private static final SimpleDateFormat yearFormat = new SimpleDateFormat("MMM dd YYYY", Locale.ENGLISH);
    private static final long sixMonths = 15811200000L;

    public static String toListTimestamp(long time) {
        Date date = new Date(time);
        if (System.currentTimeMillis() - time > 15811200000L) {
            return yearFormat.format(date);
        }
        return hourFormat.format(date);
    }

    public static String toMdtmTimestamp(long time) {
        return mdtmFormat.format(new Date(time));
    }

    public static long fromMdtmTimestamp(String time) throws ParseException {
        return mdtmFormat.parse(time).getTime();
    }

    public static <F> String format(IFileSystem<F> fs, F file) {
        return String.format("%s %3d %-8s %-8s %8d %s %s\r\n", Utils.getPermission(fs, file), fs.getHardLinks(file), fs.getOwner(file), fs.getGroup(file), fs.getSize(file), Utils.toListTimestamp(fs.getLastModified(file)), fs.getName(file));
    }

    public static <F> String getPermission(IFileSystem<F> fs, F file) {
        String perm = "";
        int perms = fs.getPermissions(file);
        perm = perm + (fs.isDirectory(file) ? (char)'d' : '-');
        perm = perm + (Utils.hasPermission(perms, 8) ? (char)'r' : '-');
        perm = perm + (Utils.hasPermission(perms, 7) ? (char)'w' : '-');
        perm = perm + (Utils.hasPermission(perms, 6) ? (char)'x' : '-');
        perm = perm + (Utils.hasPermission(perms, 5) ? (char)'r' : '-');
        perm = perm + (Utils.hasPermission(perms, 4) ? (char)'w' : '-');
        perm = perm + (Utils.hasPermission(perms, 3) ? (char)'x' : '-');
        perm = perm + (Utils.hasPermission(perms, 2) ? (char)'r' : '-');
        perm = perm + (Utils.hasPermission(perms, 1) ? (char)'w' : '-');
        perm = perm + (Utils.hasPermission(perms, 0) ? (char)'x' : '-');
        return perm;
    }

    public static <F> String getFacts(IFileSystem<F> fs, F file, String[] options) {
        String facts = "";
        boolean dir = fs.isDirectory(file);
        for (String opt : options) {
            if ((opt = opt.toLowerCase()).equals("modify")) {
                facts = facts + "modify=" + Utils.toMdtmTimestamp(fs.getLastModified(file)) + ";";
                continue;
            }
            if (opt.equals("size")) {
                facts = facts + "size=" + fs.getSize(file) + ";";
                continue;
            }
            if (opt.equals("type")) {
                facts = facts + "type=" + (dir ? "dir" : "file") + ";";
                continue;
            }
            if (!opt.equals("perm")) continue;
            int perms = fs.getPermissions(file);
            String perm = "";
            if (Utils.hasPermission(perms, 8)) {
                perm = perm + (dir ? "el" : "r");
            }
            if (Utils.hasPermission(perms, 7)) {
                perm = perm + "f";
                perm = perm + (dir ? "pcm" : "adw");
            }
            facts = facts + "perm=" + perm + ";";
        }
        facts = facts + " " + fs.getName(file) + "\r\n";
        return facts;
    }

    public static void write(OutputStream out, byte[] bytes, int len, boolean ascii) throws IOException {
        if (ascii) {
            int lastByte = 0;
            for (int i = 0; i < len; ++i) {
                int b = bytes[i];
                if (b == 10 && lastByte != 13) {
                    out.write(13);
                }
                out.write(b);
                lastByte = b;
            }
        } else {
            out.write(bytes, 0, len);
        }
    }

    public static <F> InputStream readFileSystem(IFileSystem<F> fs, F file, long start, boolean ascii) throws IOException {
        if (ascii && start > 0L) {
            BufferedInputStream in = new BufferedInputStream(fs.readFile(file, 0L));
            long offset = 0L;
            while (start >= offset++) {
                int c = ((InputStream)in).read();
                if (c == -1) {
                    throw new IOException("Couldn't skip this file. End of the file was reached");
                }
                if (c != 10) continue;
                ++offset;
            }
            return in;
        }
        return fs.readFile(file, start);
    }

    public static boolean hasPermission(int perms, int perm) {
        return (perms >> perm & 1) == 1;
    }

    public static int setPermission(int perms, int perm, boolean hasPermission) {
        perm = 1 << perm;
        return hasPermission ? perms | perm : perms & ~perm;
    }

    public static int fromOctal(String perm) {
        return Integer.parseInt(perm, 8);
    }

    public static ServerSocket createServer(int port, int backlog, InetAddress address, SSLContext context, boolean ssl) throws IOException {
        if (ssl) {
            if (context == null) {
                throw new NullPointerException("The SSL context is null");
            }
            return context.getServerSocketFactory().createServerSocket(port, backlog, address);
        }
        return new ServerSocket(port, backlog, address);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

