/*
 * Decompiled with CFR 0.152.
 */
package com.guichaguri.minimalftp.api;

import com.guichaguri.minimalftp.api.ResponseException;
import java.io.IOException;

public class CommandInfo {
    public final Command command;
    public final String help;
    public final boolean needsAuth;

    public CommandInfo(Command command, String help, boolean needsAuth) {
        this.command = command;
        this.help = help;
        this.needsAuth = needsAuth;
    }

    @FunctionalInterface
    public static interface ArgsArrayCommand
    extends Command {
        public void run(String[] var1) throws IOException;

        @Override
        default public void run(String argument) throws IOException {
            this.run(argument.split("\\s+"));
        }

        @Override
        default public void run(CommandInfo info, String argument) throws IOException {
            this.run(argument.split("\\s+"));
        }
    }

    @FunctionalInterface
    public static interface NoArgsCommand
    extends Command {
        public void run() throws IOException;

        @Override
        default public void run(String argument) throws IOException {
            this.run();
        }

        @Override
        default public void run(CommandInfo info, String argument) throws IOException {
            this.run();
        }
    }

    @FunctionalInterface
    public static interface Command {
        public void run(String var1) throws IOException;

        default public void run(CommandInfo info, String argument) throws IOException {
            if (argument.isEmpty()) {
                throw new ResponseException(501, "Missing parameters");
            }
            this.run(argument);
        }
    }
}

