/*
 * Decompiled with CFR 0.152.
 */
package com.guichaguri.minimalftp.handler;

import com.guichaguri.minimalftp.FTPConnection;
import com.guichaguri.minimalftp.Utils;
import com.guichaguri.minimalftp.api.IFileSystem;
import com.guichaguri.minimalftp.api.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class FileHandler {
    private final FTPConnection con;
    private IFileSystem fs = null;
    private Object cwd = null;
    private Object rnFile = null;
    private long start = 0L;

    public FileHandler(FTPConnection connection) {
        this.con = connection;
    }

    public IFileSystem getFileSystem() {
        return this.fs;
    }

    public void setFileSystem(IFileSystem fs) {
        this.fs = fs;
        this.cwd = fs.getRoot();
    }

    public void registerCommands() {
        this.con.registerCommand("CWD", "CWD <file>", this::cwd);
        this.con.registerCommand("CDUP", "CDUP", this::cdup);
        this.con.registerCommand("PWD", "PWD", this::pwd);
        this.con.registerCommand("MKD", "MKD <file>", this::mkd);
        this.con.registerCommand("RMD", "RMD <file>", this::rmd);
        this.con.registerCommand("DELE", "DELE <file>", this::dele);
        this.con.registerCommand("LIST", "LIST [file]", this::list);
        this.con.registerCommand("NLST", "NLST [file]", this::nlst);
        this.con.registerCommand("RETR", "RETR <file>", this::retr);
        this.con.registerCommand("STOR", "STOR <file>", this::stor);
        this.con.registerCommand("STOU", "STOU [file]", this::stou);
        this.con.registerCommand("APPE", "APPE <file>", this::appe);
        this.con.registerCommand("REST", "REST <bytes>", this::rest);
        this.con.registerCommand("ABOR", "ABOR", this::abor);
        this.con.registerCommand("ALLO", "ALLO <size>", this::allo);
        this.con.registerCommand("RNFR", "RNFR <file>", this::rnfr);
        this.con.registerCommand("RNTO", "RNTO <file>", this::rnto);
        this.con.registerCommand("SMNT", "SMNT <file>", this::smnt);
        this.con.registerSiteCommand("CHMOD", "CHMOD <perm> <file>", this::site_chmod);
        this.con.registerCommand("MDTM", "MDTM <file>", this::mdtm);
        this.con.registerCommand("SIZE", "SIZE <file>", this::size);
        this.con.registerCommand("MLST", "MLST <file>", this::mlst);
        this.con.registerCommand("MLSD", "MLSD <file>", this::mlsd);
        this.con.registerCommand("XCWD", "XCWD <file>", this::cwd);
        this.con.registerCommand("XCUP", "XCUP", this::cdup);
        this.con.registerCommand("XPWD", "XPWD", this::pwd);
        this.con.registerCommand("XMKD", "XMKD <file>", this::mkd);
        this.con.registerCommand("XRMD", "XRMD <file>", this::rmd);
        this.con.registerCommand("MFMT", "MFMT <time> <file>", this::mfmt);
        this.con.registerCommand("MD5", "MD5 <file>", this::md5);
        this.con.registerCommand("MMD5", "MMD5 <file1, file2, ...>", this::mmd5);
        this.con.registerCommand("HASH", "HASH <file>", this::hash);
        this.con.registerFeature("base");
        this.con.registerFeature("hist");
        this.con.registerFeature("REST STREAM");
        this.con.registerFeature("MDTM");
        this.con.registerFeature("SIZE");
        this.con.registerFeature("MLST Type*;Size*;Modify*;Perm*;");
        this.con.registerFeature("TVFS");
        this.con.registerFeature("MFMT");
        this.con.registerFeature("MD5");
        this.con.registerFeature("HASH MD5;SHA-1;SHA-256");
        this.con.registerOption("MLST", "Type;Size;Modify;Perm;");
        this.con.registerOption("HASH", "MD5");
    }

    private Object getFile(String path) throws IOException {
        if (path.equals("...") || path.equals("..")) {
            return this.fs.getParent(this.cwd);
        }
        if (path.equals("/")) {
            return this.fs.getRoot();
        }
        if (path.startsWith("/")) {
            return this.fs.findFile(this.fs.getRoot(), path.substring(1));
        }
        return this.fs.findFile(this.cwd, path);
    }

    private void cwd(String path) throws IOException {
        Object dir = this.getFile(path);
        if (this.fs.isDirectory(dir)) {
            this.cwd = dir;
            this.con.sendResponse(250, "The working directory was changed");
        } else {
            this.con.sendResponse(550, "Not a valid directory");
        }
    }

    private void cdup() throws IOException {
        this.cwd = this.fs.getParent(this.cwd);
        this.con.sendResponse(200, "The working directory was changed");
    }

    private void pwd() {
        String path = "/" + this.fs.getPath(this.cwd);
        this.con.sendResponse(257, '\"' + path + '\"' + " CWD Name");
    }

    private void allo() {
        this.con.sendResponse(200, "There's no need to allocate space");
    }

    private void rnfr(String path) throws IOException {
        this.rnFile = this.getFile(path);
        this.con.sendResponse(350, "Rename request received");
    }

    private void rnto(String path) throws IOException {
        if (this.rnFile == null) {
            this.con.sendResponse(503, "No rename request was received");
            return;
        }
        this.fs.rename(this.rnFile, this.getFile(path));
        this.rnFile = null;
        this.con.sendResponse(250, "File successfully renamed");
    }

    private void stor(String path) throws IOException {
        Object file = this.getFile(path);
        this.con.sendResponse(150, "Receiving a file stream for " + path);
        this.receiveStream(this.fs.writeFile(file, this.start));
        this.start = 0L;
    }

    private void stou(String[] args) throws IOException {
        Object file = null;
        String ext = ".tmp";
        if (args.length > 0) {
            file = this.getFile(args[0]);
            int i = args[0].lastIndexOf(46);
            if (i > 0) {
                ext = args[0].substring(i);
            }
        }
        while (file != null && this.fs.exists(file)) {
            String name = UUID.randomUUID().toString().replace("-", "");
            file = this.fs.findFile(this.cwd, name + ext);
        }
        this.con.sendResponse(150, "File: " + this.fs.getPath(file));
        this.receiveStream(this.fs.writeFile(file, 0L));
    }

    private void appe(String path) throws IOException {
        Object file = this.getFile(path);
        this.con.sendResponse(150, "Receiving a file stream for " + path);
        this.receiveStream(this.fs.writeFile(file, this.fs.exists(file) ? this.fs.getSize(file) : 0L));
    }

    private void retr(String path) throws IOException {
        Object file = this.getFile(path);
        this.con.sendResponse(150, "Sending the file stream for " + path + " (" + this.fs.getSize(file) + " bytes)");
        this.sendStream(Utils.readFileSystem(this.fs, file, this.start, this.con.isAsciiMode()));
        this.start = 0L;
    }

    private void rest(String byteStr) {
        long bytes = Long.parseLong(byteStr);
        if (bytes >= 0L) {
            this.start = bytes;
            this.con.sendResponse(350, "Restarting at " + bytes + ". Ready to receive a RETR or STOR command");
        } else {
            this.con.sendResponse(501, "The number of bytes should be greater or equal to 0");
        }
    }

    private void abor() throws IOException {
        this.con.abortDataTransfers();
        this.con.sendResponse(226, "All transfers were aborted successfully");
    }

    private void list(String[] args) throws IOException {
        Object dir;
        this.con.sendResponse(150, "Sending file list...");
        Object object = dir = args.length > 0 && !args[0].equals("-l") ? this.getFile(args[0]) : this.cwd;
        if (!this.fs.isDirectory(dir)) {
            this.con.sendResponse(550, "Not a directory");
            return;
        }
        StringBuilder data = new StringBuilder();
        for (Object file : this.fs.listFiles(dir)) {
            data.append(Utils.format(this.fs, file));
        }
        this.con.sendData(data.toString().getBytes("UTF-8"));
        this.con.sendResponse(226, "The list was sent");
    }

    private void nlst(String[] args) throws IOException {
        Object dir;
        this.con.sendResponse(150, "Sending file list...");
        Object object = dir = args.length > 0 && !args[0].equals("-l") ? this.getFile(args[0]) : this.cwd;
        if (!this.fs.isDirectory(dir)) {
            this.con.sendResponse(550, "Not a directory");
            return;
        }
        StringBuilder data = new StringBuilder();
        for (Object file : this.fs.listFiles(dir)) {
            data.append(this.fs.getName(file)).append("\r\n");
        }
        this.con.sendData(data.toString().getBytes("UTF-8"));
        this.con.sendResponse(226, "The list was sent");
    }

    private void rmd(String path) throws IOException {
        Object file = this.getFile(path);
        if (!this.fs.isDirectory(file)) {
            this.con.sendResponse(550, "Not a directory");
            return;
        }
        this.fs.delete(file);
        this.con.sendResponse(250, '\"' + path + '\"' + " Directory Deleted");
    }

    private void dele(String path) throws IOException {
        Object file = this.getFile(path);
        if (this.fs.isDirectory(file)) {
            this.con.sendResponse(550, "Not a file");
            return;
        }
        this.fs.delete(file);
        this.con.sendResponse(250, '\"' + path + '\"' + " File Deleted");
    }

    private void mkd(String path) throws IOException {
        Object file = this.getFile(path);
        this.fs.mkdirs(file);
        this.con.sendResponse(257, '\"' + path + '\"' + " Directory Created");
    }

    private void smnt() {
        this.con.sendResponse(502, "SMNT is not implemented in this server");
    }

    private void site_chmod(String[] cmd) throws IOException {
        if (cmd.length <= 1) {
            this.con.sendResponse(501, "Missing parameters");
            return;
        }
        this.fs.chmod(this.getFile(cmd[1]), Utils.fromOctal(cmd[0]));
        this.con.sendResponse(200, "The file permissions were successfully changed");
    }

    private void mdtm(String path) throws IOException {
        Object file = this.getFile(path);
        this.con.sendResponse(213, Utils.toMdtmTimestamp(this.fs.getLastModified(file)));
    }

    private void size(String path) throws IOException {
        Object file = this.getFile(path);
        this.con.sendResponse(213, Long.toString(this.fs.getSize(file)));
    }

    private void mlst(String[] args) throws IOException {
        Object file;
        Object object = file = args.length > 0 ? this.getFile(args[0]) : this.cwd;
        if (!this.fs.exists(file)) {
            this.con.sendResponse(550, "File not found");
            return;
        }
        String[] options = this.con.getOption("MLST").split(";");
        String facts = Utils.getFacts(this.fs, file, options);
        this.con.sendResponse(250, "- Listing " + this.fs.getName(file) + "\r\n" + facts);
        this.con.sendResponse(250, "End");
    }

    private void mlsd(String[] args) throws IOException {
        Object file;
        Object object = file = args.length > 0 ? this.getFile(args[0]) : this.cwd;
        if (!this.fs.isDirectory(file)) {
            this.con.sendResponse(550, "Not a directory");
            return;
        }
        this.con.sendResponse(150, "Sending file information list...");
        String[] options = this.con.getOption("MLST").split(";");
        StringBuilder data = new StringBuilder();
        for (Object f : this.fs.listFiles(file)) {
            data.append(Utils.getFacts(this.fs, f, options));
        }
        this.con.sendData(data.toString().getBytes("UTF-8"));
        this.con.sendResponse(226, "The file list was sent!");
    }

    private void mfmt(String[] args) throws IOException {
        long time;
        if (args.length < 2) {
            this.con.sendResponse(501, "Missing arguments");
            return;
        }
        Object file = this.getFile(args[1]);
        if (!this.fs.exists(file)) {
            this.con.sendResponse(550, "File not found");
            return;
        }
        try {
            time = Utils.fromMdtmTimestamp(args[0]);
        }
        catch (ParseException ex) {
            this.con.sendResponse(500, "Couldn't parse the time");
            return;
        }
        this.fs.touch(file, time);
        this.con.sendResponse(213, "Modify=" + args[0] + "; " + this.fs.getPath(file));
    }

    private void md5(String path) throws IOException {
        String p = path = path.trim();
        if (p.length() > 2 && p.startsWith("\"") && p.endsWith("\"")) {
            p = p.substring(1, p.length() - 1).trim();
        }
        try {
            Object file = this.getFile(p);
            byte[] digest = this.fs.getDigest(file, "MD5");
            String md5 = DatatypeConverter.printHexBinary((byte[])digest);
            this.con.sendResponse(251, path + " " + md5);
        }
        catch (NoSuchAlgorithmException ex) {
            this.con.sendResponse(504, ex.getMessage());
        }
    }

    private void mmd5(String args) throws IOException {
        String[] paths = args.split(",");
        StringBuilder response = new StringBuilder();
        try {
            for (String path : paths) {
                String p = path = path.trim();
                if (p.length() > 2 && p.startsWith("\"") && p.endsWith("\"")) {
                    p = p.substring(1, p.length() - 1).trim();
                }
                Object file = this.getFile(p);
                byte[] digest = this.fs.getDigest(file, "MD5");
                String md5 = DatatypeConverter.printHexBinary((byte[])digest);
                if (response.length() > 0) {
                    response.append(", ");
                }
                response.append(path).append(" ").append(md5);
            }
            this.con.sendResponse(paths.length == 1 ? 251 : 252, response.toString());
        }
        catch (NoSuchAlgorithmException ex) {
            this.con.sendResponse(504, ex.getMessage());
        }
    }

    private void hash(String path) throws IOException {
        try {
            Object file = this.getFile(path);
            String hash = this.con.getOption("HASH");
            byte[] digest = this.fs.getDigest(file, hash);
            String hex = DatatypeConverter.printHexBinary((byte[])digest);
            this.con.sendResponse(213, String.format("%s 0-%s %s %s", hash, this.fs.getSize(file), hex, this.fs.getName(file)));
        }
        catch (NoSuchAlgorithmException ex) {
            this.con.sendResponse(504, ex.getMessage());
        }
    }

    private void sendStream(InputStream in) {
        new Thread(() -> {
            try {
                this.con.sendData(in);
                this.con.sendResponse(226, "File sent!");
            }
            catch (ResponseException ex) {
                this.con.sendResponse(ex.getCode(), ex.getMessage());
            }
            catch (Exception ex) {
                this.con.sendResponse(451, ex.getMessage());
            }
        }).start();
    }

    private void receiveStream(OutputStream out) {
        new Thread(() -> {
            try {
                this.con.receiveData(out);
                this.con.sendResponse(226, "File received!");
            }
            catch (ResponseException ex) {
                this.con.sendResponse(ex.getCode(), ex.getMessage());
            }
            catch (Exception ex) {
                this.con.sendResponse(451, ex.getMessage());
            }
        }).start();
    }
}

