/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

enum ClientConfigSections {
    HAZELCAST_CLIENT("hazelcast-client", false),
    IMPORT("import", true),
    SECURITY("security", false),
    PROXY_FACTORIES("proxy-factories", false),
    PROPERTIES("properties", false),
    SERIALIZATION("serialization", false),
    NATIVE_MEMORY("native-memory", false),
    GROUP("group", false),
    LISTENERS("listeners", false),
    NETWORK("network", false),
    LOAD_BALANCER("load-balancer", false),
    NEAR_CACHE("near-cache", true),
    QUERY_CACHES("query-caches", false),
    EXECUTOR_POOL_SIZE("executor-pool-size", false),
    LICENSE_KEY("license-key", false),
    INSTANCE_NAME("instance-name", false),
    CONNECTION_STRATEGY("connection-strategy", false),
    USER_CODE_DEPLOYMENT("user-code-deployment", false),
    FLAKE_ID_GENERATOR("flake-id-generator", true),
    RELIABLE_TOPIC("reliable-topic", true),
    LABELS("client-labels", false);

    final String name;
    final boolean multipleOccurrence;

    private ClientConfigSections(String name, boolean multipleOccurrence) {
        this.name = name;
        this.multipleOccurrence = multipleOccurrence;
    }

    public static boolean canOccurMultipleTimes(String name) {
        for (ClientConfigSections element : ClientConfigSections.values()) {
            if (!name.equals(element.name)) continue;
            return element.multipleOccurrence;
        }
        return true;
    }

    public boolean isEqual(String name) {
        return this.name.equals(name);
    }
}

