/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.ClientNotAllowedInClusterException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.Addresses;
import com.hazelcast.client.connection.ClientConnectionStrategy;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.connection.nio.ClusterConnectorService;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.ClientDiscoveryService;
import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.LifecycleServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ClusterConnectorServiceImpl
implements ClusterConnectorService,
ConnectionListener {
    private static final int DEFAULT_CONNECTION_ATTEMPT_LIMIT_SYNC = 2;
    private static final int DEFAULT_CONNECTION_ATTEMPT_LIMIT_ASYNC = 20;
    private final ILogger logger;
    private final HazelcastClientInstanceImpl client;
    private final ClientConnectionManagerImpl connectionManager;
    private final ClientConnectionStrategy connectionStrategy;
    private final ExecutorService clusterConnectionExecutor;
    private final boolean shuffleMemberList;
    private final WaitStrategy waitStrategy;
    private final ClientDiscoveryService discoveryService;
    private volatile Address ownerConnectionAddress;
    private volatile Address previousOwnerConnectionAddress;

    public ClusterConnectorServiceImpl(HazelcastClientInstanceImpl client, ClientConnectionManagerImpl connectionManager, ClientConnectionStrategy connectionStrategy, ClientDiscoveryService discoveryService) {
        this.client = client;
        this.connectionManager = connectionManager;
        this.logger = client.getLoggingService().getLogger(ClusterConnectorService.class);
        this.connectionStrategy = connectionStrategy;
        this.clusterConnectionExecutor = this.createSingleThreadExecutorService(client);
        this.shuffleMemberList = client.getProperties().getBoolean(ClientProperty.SHUFFLE_MEMBER_LIST);
        this.discoveryService = discoveryService;
        this.waitStrategy = this.initializeWaitStrategy(client.getClientConfig());
    }

    private WaitStrategy initializeWaitStrategy(ClientConfig clientConfig) {
        ClientConnectionStrategyConfig connectionStrategyConfig = clientConfig.getConnectionStrategyConfig();
        ConnectionRetryConfig expoRetryConfig = connectionStrategyConfig.getConnectionRetryConfig();
        if (expoRetryConfig.isEnabled()) {
            return new ExponentialWaitStrategy(expoRetryConfig.getInitialBackoffMillis(), expoRetryConfig.getMaxBackoffMillis(), expoRetryConfig.getMultiplier(), expoRetryConfig.isFailOnMaxBackoff(), expoRetryConfig.getJitter());
        }
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
        boolean isAsync = connectionStrategyConfig.isAsyncStart();
        int connectionAttemptLimit = networkConfig.getConnectionAttemptLimit();
        connectionAttemptLimit = connectionAttemptLimit < 0 ? (isAsync ? 20 : 2) : (connectionAttemptLimit == 0 ? Integer.MAX_VALUE : connectionAttemptLimit);
        return new DefaultWaitStrategy(connectionAttemptPeriod, connectionAttemptLimit);
    }

    @Override
    public void connectToCluster() {
        try {
            this.connectToClusterAsync().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public boolean isClusterAvailable() {
        return this.getOwnerConnectionAddress() != null;
    }

    public Address getOwnerConnectionAddress() {
        return this.ownerConnectionAddress;
    }

    public void setOwnerConnectionAddress(Address ownerConnectionAddress) {
        if (this.ownerConnectionAddress != null) {
            this.previousOwnerConnectionAddress = this.ownerConnectionAddress;
        }
        this.ownerConnectionAddress = ownerConnectionAddress;
    }

    private Connection connectAsOwner(Address address) {
        Connection connection = null;
        try {
            this.logger.info("Trying to connect to " + address + " as owner member");
            connection = this.connectionManager.getOrConnect(address, true);
            this.setOwnerConnectionAddress(connection.getEndPoint());
            this.client.onClusterConnect(connection);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
            this.connectionStrategy.onClusterConnect();
        }
        catch (ConfigurationException e) {
            this.setOwnerConnectionAddress(null);
            this.logger.warning("Exception during initial connection to " + address + ": " + (Object)((Object)e));
            if (null != connection) {
                connection.close("Could not connect to " + address + " as owner", (Throwable)e);
            }
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        catch (ClientNotAllowedInClusterException e) {
            this.setOwnerConnectionAddress(null);
            this.logger.warning("Exception during initial connection to " + address + ": " + (Object)((Object)e));
            if (null != connection) {
                connection.close("Could not connect to " + address + " as owner", (Throwable)((Object)e));
            }
            throw e;
        }
        catch (Exception e) {
            this.setOwnerConnectionAddress(null);
            this.logger.warning("Exception during initial connection to " + address + ": " + e);
            if (null != connection) {
                connection.close("Could not connect to " + address + " as owner", (Throwable)e);
            }
            return null;
        }
        return connection;
    }

    private void fireLifecycleEvent(LifecycleEvent.LifecycleState state) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        lifecycleService.fireLifecycleEvent(state);
    }

    private ExecutorService createSingleThreadExecutorService(HazelcastClientInstanceImpl client) {
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        SingleExecutorThreadFactory threadFactory = new SingleExecutorThreadFactory(classLoader, client.getName() + ".cluster-");
        return Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
    }

    private void connectToClusterInternal() {
        CandidateClusterContext currentClusterContext = this.discoveryService.current();
        this.logger.info("Trying to connect to cluster with name: " + currentClusterContext.getName());
        if (this.connectToCandidate(currentClusterContext)) {
            return;
        }
        this.discoveryService.resetSearch();
        while (this.discoveryService.hasNext() && this.client.getLifecycleService().isRunning()) {
            CandidateClusterContext candidateClusterContext = this.discoveryService.next();
            this.beforeClusterSwitch(candidateClusterContext);
            this.logger.info("Trying to connect to next cluster with name: " + candidateClusterContext.getName());
            if (!this.connectToCandidate(candidateClusterContext)) continue;
            this.client.getQueryCacheContext().recreateAllCaches();
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CHANGED_CLUSTER);
            return;
        }
        if (!this.client.getLifecycleService().isRunning()) {
            throw new IllegalStateException("Client is being shutdown.");
        }
        throw new IllegalStateException("Unable to connect to any cluster.");
    }

    private void beforeClusterSwitch(CandidateClusterContext context) {
        try {
            this.client.getNearCacheManager().clearAllNearCaches();
        }
        catch (Throwable e) {
            this.logger.warning("Error when clearing near caches before cluster switch ", e);
        }
        this.client.getClientClusterService().reset();
        this.client.getClientPartitionService().reset();
        this.client.getConnectionManager().beforeClusterSwitch(context);
        ((ClientLoggingService)this.client.getLoggingService()).updateGroupName(context.getName());
    }

    private boolean connectToCandidate(CandidateClusterContext context) {
        HashSet<Address> triedAddresses = new HashSet<Address>();
        this.client.getConnectionManager().setCandidateClusterContext(context);
        this.waitStrategy.reset();
        block2: do {
            Collection<Address> addresses = this.getPossibleMemberAddresses(context.getAddressProvider());
            for (Address address : addresses) {
                if (!this.client.getLifecycleService().isRunning()) {
                    throw new IllegalStateException("Giving up retrying to connect to cluster since client is shutdown.");
                }
                triedAddresses.add(address);
                try {
                    Connection connection = this.connectAsOwner(address);
                    if (connection == null) continue;
                    return true;
                }
                catch (ClientNotAllowedInClusterException e) {
                    break block2;
                }
            }
            if (this.client.getLifecycleService().isRunning()) continue;
            throw new IllegalStateException("Client is being shutdown.");
        } while (this.waitStrategy.sleep());
        this.logger.warning("Unable to connect to any address for cluster: " + context.getName() + ". The following addresses were tried: " + triedAddresses);
        return false;
    }

    @Override
    public Future<Void> connectToClusterAsync() {
        return this.clusterConnectionExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    ClusterConnectorServiceImpl.this.connectToClusterInternal();
                }
                catch (Throwable e) {
                    ClusterConnectorServiceImpl.this.logger.warning("Could not connect to any cluster, shutting down the client: " + e.getMessage());
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ClusterConnectorServiceImpl.this.client.getLifecycleService().shutdown();
                            }
                            catch (Exception exception) {
                                ClusterConnectorServiceImpl.this.logger.severe("Exception during client shutdown", (Throwable)exception);
                            }
                        }
                    }, ClusterConnectorServiceImpl.this.client.getName() + ".clientShutdown-").start();
                    throw ExceptionUtil.rethrow((Throwable)e);
                }
                return null;
            }
        });
    }

    Collection<Address> getPossibleMemberAddresses(AddressProvider addressProvider) {
        LinkedHashSet addresses = new LinkedHashSet();
        Collection<Member> memberList = this.client.getClientClusterService().getMemberList();
        for (Member member : memberList) {
            addresses.add(member.getAddress());
        }
        if (this.shuffleMemberList) {
            addresses = (LinkedHashSet)ClusterConnectorServiceImpl.shuffle(addresses);
        }
        LinkedHashSet<Address> providedAddresses = new LinkedHashSet<Address>();
        try {
            Addresses result = addressProvider.loadAddresses();
            if (this.shuffleMemberList) {
                Collections.shuffle(result.primary());
                Collections.shuffle(result.secondary());
            }
            providedAddresses.addAll(result.primary());
            providedAddresses.addAll(result.secondary());
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.warning("Exception from AddressProvider: " + this.discoveryService, (Throwable)e);
        }
        addresses.addAll(providedAddresses);
        if (this.previousOwnerConnectionAddress != null) {
            addresses.remove(this.previousOwnerConnectionAddress);
            addresses.add(this.previousOwnerConnectionAddress);
        }
        return addresses;
    }

    private static <T> Set<T> shuffle(Set<T> set) {
        ArrayList<T> shuffleMe = new ArrayList<T>(set);
        Collections.shuffle(shuffleMe);
        return new LinkedHashSet<T>(shuffleMe);
    }

    @Override
    public void shutdown() {
        ClientExecutionServiceImpl.shutdownExecutor("cluster", this.clusterConnectionExecutor, this.logger);
    }

    public void connectionAdded(Connection connection) {
    }

    public void connectionRemoved(Connection connection) {
        final ClientConnection clientConnection = (ClientConnection)connection;
        if (clientConnection.isAuthenticatedAsOwner()) {
            this.clusterConnectionExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Address endpoint = clientConnection.getEndPoint();
                    if (endpoint == null || !endpoint.equals((Object)ClusterConnectorServiceImpl.this.ownerConnectionAddress)) {
                        return;
                    }
                    ClusterConnectorServiceImpl.this.setOwnerConnectionAddress(null);
                    ClusterConnectorServiceImpl.this.connectionStrategy.onDisconnectFromCluster();
                    ClusterConnectorServiceImpl.this.client.onClusterDisconnect();
                    if (ClusterConnectorServiceImpl.this.client.getLifecycleService().isRunning()) {
                        ClusterConnectorServiceImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
                    }
                }
            });
        }
    }

    class ExponentialWaitStrategy
    implements WaitStrategy {
        private final int initialBackoffMillis;
        private final int maxBackoffMillis;
        private final double multiplier;
        private final boolean failOnMaxBackoff;
        private final double jitter;
        private final Random random = new Random();
        private int attempt;
        private int currentBackoffMillis;

        ExponentialWaitStrategy(int initialBackoffMillis, int maxBackoffMillis, double multiplier, boolean failOnMaxBackoff, double jitter) {
            this.initialBackoffMillis = initialBackoffMillis;
            this.maxBackoffMillis = maxBackoffMillis;
            this.multiplier = multiplier;
            this.failOnMaxBackoff = failOnMaxBackoff;
            this.jitter = jitter;
        }

        @Override
        public void reset() {
            this.attempt = 0;
            this.currentBackoffMillis = Math.min(this.maxBackoffMillis, this.initialBackoffMillis);
        }

        @Override
        public boolean sleep() {
            ++this.attempt;
            if (this.failOnMaxBackoff && this.currentBackoffMillis >= this.maxBackoffMillis) {
                ClusterConnectorServiceImpl.this.logger.warning(String.format("Unable to get live cluster connection, attempt %d.", this.attempt));
                return false;
            }
            long actualSleepTime = (long)((double)this.currentBackoffMillis - (double)this.currentBackoffMillis * this.jitter + (double)this.currentBackoffMillis * this.jitter * this.random.nextDouble());
            ClusterConnectorServiceImpl.this.logger.warning(String.format("Unable to get live cluster connection, retry in %d ms, attempt %d, retry timeout millis %d cap", actualSleepTime, this.attempt, this.maxBackoffMillis));
            try {
                Thread.sleep(actualSleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            this.currentBackoffMillis = (int)Math.min((double)this.currentBackoffMillis * this.multiplier, (double)this.maxBackoffMillis);
            return true;
        }
    }

    class DefaultWaitStrategy
    implements WaitStrategy {
        private final int connectionAttemptPeriod;
        private final int connectionAttemptLimit;
        private int attempt;

        DefaultWaitStrategy(int connectionAttemptPeriod, int connectionAttemptLimit) {
            this.connectionAttemptPeriod = connectionAttemptPeriod;
            this.connectionAttemptLimit = connectionAttemptLimit;
        }

        @Override
        public void reset() {
            this.attempt = 0;
        }

        @Override
        public boolean sleep() {
            ++this.attempt;
            if (this.attempt >= this.connectionAttemptLimit) {
                ClusterConnectorServiceImpl.this.logger.warning(String.format("Unable to get live cluster connection, attempt %d of %d.", this.attempt, this.connectionAttemptLimit));
                return false;
            }
            ClusterConnectorServiceImpl.this.logger.warning(String.format("Unable to get live cluster connection, retry in %d ms, attempt %d of %d.", this.connectionAttemptPeriod, this.attempt, this.connectionAttemptLimit));
            try {
                Thread.sleep(this.connectionAttemptPeriod);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
    }

    static interface WaitStrategy {
        public void reset();

        public boolean sleep();
    }
}

