/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionalSetAddCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalSetRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalSetSizeCodec;
import com.hazelcast.client.proxy.txn.AbstractClientTxnCollectionProxy;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;

public class ClientTxnSetProxy<E>
extends AbstractClientTxnCollectionProxy
implements TransactionalSet<E> {
    public ClientTxnSetProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean add(E e) {
        Preconditions.checkNotNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalSetAddCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)value);
        ClientMessage response = this.invoke(request);
        return TransactionalSetAddCodec.decodeResponse((ClientMessage)response).response;
    }

    public boolean remove(E e) {
        Preconditions.checkNotNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalSetRemoveCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)value);
        ClientMessage response = this.invoke(request);
        return TransactionalSetRemoveCodec.decodeResponse((ClientMessage)response).response;
    }

    public int size() {
        ClientMessage request = TransactionalSetSizeCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return TransactionalSetSizeCodec.decodeResponse((ClientMessage)response).response;
    }

    public String getServiceName() {
        return "hz:impl:setService";
    }
}

