/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.base;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.base.IIterableIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.function.Function;

public class MapperIterator<SRCTYPE, ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends SRCTYPE> m_aBaseIter;
    private final Function<? super SRCTYPE, ? extends ELEMENTTYPE> m_aConverter;

    public MapperIterator(@Nonnull IIterableIterator<? extends SRCTYPE> iIterableIterator, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this(iIterableIterator.iterator(), function);
    }

    public MapperIterator(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this(iterable.iterator(), function);
    }

    public MapperIterator(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.m_aBaseIter = (Iterator)ValueEnforcer.notNull(iterator, (String)"BaseIterator");
        this.m_aConverter = (Function)ValueEnforcer.notNull(function, (String)"Filter");
    }

    @Nonnull
    public Function<? super SRCTYPE, ? extends ELEMENTTYPE> getConverter() {
        return this.m_aConverter;
    }

    @Override
    public boolean hasNext() {
        return this.m_aBaseIter.hasNext();
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        SRCTYPE SRCTYPE = this.m_aBaseIter.next();
        return this.m_aConverter.apply(SRCTYPE);
    }

    @Override
    public void remove() {
        this.m_aBaseIter.remove();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseIter", this.m_aBaseIter).append("Converter", this.m_aConverter).getToString();
    }
}

