/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Vector;
import java.util.function.Function;
import java.util.function.Predicate;

public class CommonsVector<ELEMENTTYPE>
extends Vector<ELEMENTTYPE>
implements ICommonsList<ELEMENTTYPE> {
    public CommonsVector() {
    }

    public CommonsVector(@Nonnegative int n) {
        super(n);
    }

    public CommonsVector(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        super(CollectionHelper.getSize(collection));
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public CommonsVector(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        this.addAll(iterable);
    }

    public <SRCTYPE> CommonsVector(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(CollectionHelper.getSize(collection));
        this.addAllMapped(collection, function);
    }

    public <SRCTYPE> CommonsVector(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.addAllMapped(iterable, function);
    }

    public CommonsVector(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        super(1);
        this.add(ELEMENTTYPE);
    }

    @SafeVarargs
    public CommonsVector(ELEMENTTYPE ... ELEMENTTYPEArray) {
        super(ArrayHelper.getSize((Object[])ELEMENTTYPEArray));
        this.addAll(ELEMENTTYPEArray);
    }

    public <SRCTYPE> CommonsVector(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(ArrayHelper.getSize((Object[])SRCTYPEArray));
        this.addAllMapped(SRCTYPEArray, function);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <T> CommonsVector<T> createInstance() {
        return new CommonsVector<ELEMENTTYPE>();
    }

    @Nonnull
    @ReturnsMutableCopy
    public CommonsVector<ELEMENTTYPE> getClone() {
        return new CommonsVector<CommonsVector>(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsVector<? super ELEMENTTYPE> commonsVector = new CommonsVector<ELEMENTTYPE>(CollectionHelper.getSize(iterable));
        commonsVector.addAll(iterable, predicate);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> CommonsVector<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = new CommonsVector<ELEMENTTYPE>(CollectionHelper.getSize(iterable));
        commonsVector.addAllMapped(iterable, predicate, function);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> createFiltered(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsVector<? super ELEMENTTYPE> commonsVector = new CommonsVector<ELEMENTTYPE>(ArrayHelper.getSize((Object[])ELEMENTTYPEArray));
        commonsVector.addAll(ELEMENTTYPEArray, predicate);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> CommonsVector<ELEMENTTYPE> createFiltered(@Nullable SRCTYPE[] SRCTYPEArray, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = new CommonsVector<ELEMENTTYPE>(ArrayHelper.getSize((Object[])SRCTYPEArray));
        commonsVector.addAllMapped(SRCTYPEArray, predicate, function);
        return commonsVector;
    }
}

