/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.queue;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionFind;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsIterableIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public final class QueueHelper {
    private QueueHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nonnegative int n) {
        return new PriorityQueue(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue() {
        return new PriorityQueue();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> PriorityQueue<DSTTYPE> newQueueMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(collection.size());
        for (SRCTYPE SRCTYPE : collection) {
            priorityQueue.add((int)function.apply(SRCTYPE));
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> PriorityQueue<DSTTYPE> newQueueMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty((Object[])SRCTYPEArray)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(SRCTYPEArray.length);
        for (SRCTYPE SRCTYPE : SRCTYPEArray) {
            priorityQueue.add((int)function.apply(SRCTYPE));
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nonnull ELEMENTTYPE ELEMENTTYPE) {
        PriorityQueue<boolean> priorityQueue = QueueHelper.newQueue(true);
        priorityQueue.add((boolean)ELEMENTTYPE);
        return priorityQueue;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(ELEMENTTYPEArray.length);
        Collections.addAll(priorityQueue, ELEMENTTYPEArray);
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                priorityQueue.add(enumeration.nextElement());
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (iterator != null) {
            while (iterator.hasNext()) {
                priorityQueue.add(iterator.next());
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                priorityQueue.add(ELEMENTTYPE);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        return new PriorityQueue<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(collection.size());
        CollectionFind.findAll(collection, predicate, priorityQueue::add);
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        if (iCommonsIterableIterator == null) {
            return QueueHelper.newQueue(false);
        }
        return QueueHelper.newQueue(iCommonsIterableIterator.iterator());
    }
}

