/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.map;

import com.helger.commons.annotation.UseDirectEqualsAndHashCode;
import com.helger.commons.collection.map.LRUMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LoggingLRUMap<KEYTYPE, VALUETYPE>
extends LRUMap<KEYTYPE, VALUETYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingLRUMap.class);
    private String m_sMapName;

    public LoggingLRUMap(@Nonnegative int n) {
        super(n);
    }

    public LoggingLRUMap(@Nonnull LoggingLRUMap<KEYTYPE, VALUETYPE> loggingLRUMap) {
        super(loggingLRUMap);
        this.setMapName(loggingLRUMap.m_sMapName);
    }

    @Override
    @Nonnull
    public LoggingLRUMap<KEYTYPE, VALUETYPE> getClone() {
        return new LoggingLRUMap<KEYTYPE, VALUETYPE>(this);
    }

    @Nullable
    public String getMapName() {
        return this.m_sMapName;
    }

    @Nonnull
    public final LoggingLRUMap<KEYTYPE, VALUETYPE> setMapName(@Nullable String string) {
        this.m_sMapName = string;
        return this;
    }

    @Override
    protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull Map.Entry<KEYTYPE, VALUETYPE> entry) {
        LOGGER.warn("Map" + (String)(this.m_sMapName != null ? " '" + this.m_sMapName + "'" : "") + " is full with " + n + " \u2265 " + this.getMaxSize() + " items! Removed key (" + entry.getKey() + ") and value (" + entry.getValue() + ")");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LoggingLRUMap loggingLRUMap = (LoggingLRUMap)object;
        return EqualsHelper.equals(this.m_sMapName, loggingLRUMap.m_sMapName);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sMapName).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("MapName", this.m_sMapName).getToString();
    }
}

