/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.inmemory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.inmemory.IMemoryReadableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMemoryReadableResource
implements IMemoryReadableResource {
    private final String m_sResourceID;

    protected AbstractMemoryReadableResource(@Nonnull @Nonempty String string) {
        this.m_sResourceID = ValueEnforcer.notEmpty(string, "ResourceID");
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getResourceID() {
        return this.m_sResourceID;
    }

    @Override
    @Nonnull
    public String getPath() {
        return "";
    }

    @Override
    @Nullable
    public URL getAsURL() {
        return null;
    }

    @Override
    @Nullable
    public File getAsFile() {
        return null;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    @Nonnull
    public IReadableResource getReadableCloneForPath(@Nonnull String string) {
        throw new UnsupportedOperationException("Cannot clone in-memory resource '" + this.m_sResourceID + "' for path '" + string + "'");
    }

    public String toString() {
        return new ToStringGenerator(this).append("ResourceID", this.m_sResourceID).getToString();
    }
}

