/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.state.IEnabledIndicator;
import com.helger.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class ConditionalLogger
implements IEnabledIndicator {
    private final Logger m_aLogger;
    private final AtomicBoolean m_aEnabled;

    public ConditionalLogger(@Nonnull Logger logger) {
        this(logger, GlobalDebug.isDebugMode());
    }

    public ConditionalLogger(@Nonnull Logger logger, boolean bl) {
        ValueEnforcer.notNull(logger, "Logger");
        this.m_aLogger = logger;
        this.m_aEnabled = new AtomicBoolean(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.m_aEnabled.get();
    }

    public boolean setEnabled(boolean bl) {
        return this.m_aEnabled.getAndSet(bl);
    }

    public void trace(@Nonnull Supplier<String> supplier) {
        if (this.isEnabled() && this.m_aLogger.isTraceEnabled()) {
            this.m_aLogger.trace(supplier.get());
        }
    }

    public void trace(@Nonnull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled() && this.m_aLogger.isTraceEnabled()) {
            this.m_aLogger.trace(supplier.get(), (Throwable)exception);
        }
    }

    public void debug(@Nonnull Supplier<String> supplier) {
        if (this.isEnabled() && this.m_aLogger.isDebugEnabled()) {
            this.m_aLogger.debug(supplier.get());
        }
    }

    public void debug(@Nonnull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled() && this.m_aLogger.isDebugEnabled()) {
            this.m_aLogger.debug(supplier.get(), (Throwable)exception);
        }
    }

    public void info(@Nonnull String string) {
        if (this.isEnabled()) {
            this.m_aLogger.info(string);
        }
    }

    public void info(@Nonnull Supplier<String> supplier) {
        if (this.isEnabled()) {
            this.m_aLogger.info(supplier.get());
        }
    }

    public void info(@Nonnull String string, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.info(string, (Throwable)exception);
        }
    }

    public void info(@Nonnull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.info(supplier.get(), (Throwable)exception);
        }
    }

    public void warn(@Nonnull String string) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(string);
        }
    }

    public void warn(@Nonnull Supplier<String> supplier) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(supplier.get());
        }
    }

    public void warn(@Nonnull String string, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(string, (Throwable)exception);
        }
    }

    public void warn(@Nonnull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.warn(supplier.get(), (Throwable)exception);
        }
    }

    public void error(@Nonnull String string) {
        if (this.isEnabled()) {
            this.m_aLogger.error(string);
        }
    }

    public void error(@Nonnull Supplier<String> supplier) {
        if (this.isEnabled()) {
            this.m_aLogger.error(supplier.get());
        }
    }

    public void error(@Nonnull String string, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.error(string, (Throwable)exception);
        }
    }

    public void error(@Nonnull Supplier<String> supplier, @Nullable Exception exception) {
        if (this.isEnabled()) {
            this.m_aLogger.error(supplier.get(), (Throwable)exception);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("Enabled", this.isEnabled()).append("Logger", this.m_aLogger).getToString();
    }
}

