/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.pool;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.ESuccess;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public interface IObjectPoolFactory<DATATYPE> {
    @Nonnull
    public DATATYPE create();

    @Nonnull
    public ESuccess activate(@Nonnull DATATYPE var1);

    public void passivate(@Nonnull DATATYPE var1);

    @Nonnull
    public static <T> IObjectPoolFactory<T> wrap(final @Nonnull Supplier<? extends T> supplier) {
        ValueEnforcer.notNull(supplier, "Supplier");
        return new IObjectPoolFactory<T>(){

            @Override
            @Nonnull
            public T create() {
                return supplier.get();
            }

            @Override
            @Nonnull
            public ESuccess activate(@Nonnull T t) {
                return ESuccess.SUCCESS;
            }

            @Override
            public void passivate(@Nonnull T t) {
            }
        };
    }
}

