/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import jakarta.annotation.Nullable;

@ThreadSafe
public final class ScopeHelper {
    public static final boolean DEFAULT_DEBUG_LIFE_CYCLE = false;
    public static final boolean DEFAULT_DEBUG_GLOBAL_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_SESSION_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_REQUEST_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_WITH_STACK_TRACE = false;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugLifeCycle = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugGlobalScope = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugSessionScope = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugRequestScope = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugWithStackTrace = false;

    private ScopeHelper() {
    }

    public static void setLifeCycleDebuggingEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugLifeCycle = bl;
        });
    }

    public static boolean isLifeCycleDebuggingEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugLifeCycle);
    }

    public static void setDebugGlobalScopeEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugGlobalScope = bl;
        });
    }

    public static boolean isDebugGlobalScopeEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugGlobalScope);
    }

    public static void setDebugSessionScopeEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugSessionScope = bl;
        });
    }

    public static boolean isDebugSessionScopeEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugSessionScope);
    }

    public static void setDebugRequestScopeEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugRequestScope = bl;
        });
    }

    public static boolean isDebugRequestScopeEnabled() {
        RW_LOCK.readLock().lock();
        try {
            boolean bl = s_bDebugRequestScope;
            return bl;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static void setDebugWithStackTrace(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugWithStackTrace = bl;
        });
    }

    public static boolean isDebugWithStackTrace() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugWithStackTrace);
    }

    public static boolean isDebugGlobalScopeLifeCycle() {
        return ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugGlobalScopeEnabled();
    }

    public static boolean isDebugSessionScopeLifeCycle() {
        return ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugSessionScopeEnabled();
    }

    public static boolean isDebugRequestScopeLifeCycle() {
        return ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugRequestScopeEnabled();
    }

    @Nullable
    public static Exception getDebugException() {
        return ScopeHelper.isDebugWithStackTrace() ? new DebugScopeException() : null;
    }

    public static class DebugScopeException
    extends Exception {
    }
}

