/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.security.authentication.credentials.AuthCredentialToSubjectResolverManager;
import com.helger.security.authentication.credentials.AuthCredentialValidatorManager;
import com.helger.security.authentication.credentials.IAuthCredentials;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.security.authentication.result.AuthIdentification;
import com.helger.security.authentication.result.AuthIdentificationResult;
import com.helger.security.authentication.result.AuthTokenRegistry;
import com.helger.security.authentication.result.IAuthToken;
import com.helger.security.authentication.subject.IAuthSubject;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AuthIdentificationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthIdentificationManager.class);

    private AuthIdentificationManager() {
    }

    @Nonnull
    public static AuthIdentificationResult validateLoginCredentialsAndCreateToken(@Nonnull IAuthCredentials iAuthCredentials) {
        IAuthSubject iAuthSubject;
        ValueEnforcer.notNull((Object)iAuthCredentials, (String)"Credentials");
        ICredentialValidationResult iCredentialValidationResult = AuthCredentialValidatorManager.validateCredentials(iAuthCredentials);
        if (iCredentialValidationResult.isFailure()) {
            LOGGER.warn("Credentials have been rejected: " + String.valueOf(iAuthCredentials));
            return AuthIdentificationResult.createFailure(iCredentialValidationResult);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Credentials have been accepted: " + String.valueOf(iAuthCredentials));
        }
        if ((iAuthSubject = AuthCredentialToSubjectResolverManager.getSubjectFromCredentials(iAuthCredentials)) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Credentials " + String.valueOf(iAuthCredentials) + " correspond to subject " + String.valueOf(iAuthSubject));
            }
        } else {
            LOGGER.error("Failed to resolve credentials " + String.valueOf(iAuthCredentials) + " to an auth subject!");
        }
        AuthIdentification authIdentification = new AuthIdentification(iAuthSubject);
        IAuthToken iAuthToken = AuthTokenRegistry.createToken(authIdentification, 0);
        return AuthIdentificationResult.createSuccess(iAuthToken);
    }
}

