/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.certificate;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.certificate.CertificateHelper;
import com.helger.security.certificate.ECertificateCheckResult;
import com.helger.security.certificate.TrustedCACertificates;
import com.helger.security.revocation.CertificateRevocationCheckerDefaults;
import com.helger.security.revocation.ERevocationCheckMode;
import com.helger.security.revocation.RevocationCheckBuilder;
import com.helger.security.revocation.RevocationCheckResultCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;

@NotThreadSafe
public class TrustedCAChecker {
    private final TrustedCACertificates m_aTrustedCAs = new TrustedCACertificates();
    private final RevocationCheckResultCache m_aRevocationCache;

    public TrustedCAChecker(X509Certificate ... x509CertificateArray) {
        ValueEnforcer.notNullNoNullValue((Object[])x509CertificateArray, (String)"CACerts");
        for (X509Certificate x509Certificate2 : x509CertificateArray) {
            this.m_aTrustedCAs.addTrustedCACertificate(x509Certificate2);
        }
        this.m_aRevocationCache = new RevocationCheckResultCache(x509Certificate -> ((RevocationCheckBuilder)((RevocationCheckBuilder)((RevocationCheckBuilder)new RevocationCheckBuilder().certificate((X509Certificate)x509Certificate)).validCAs(x509CertificateArray)).checkMode(CertificateRevocationCheckerDefaults.getRevocationCheckMode())).build(), CertificateRevocationCheckerDefaults.DEFAULT_REVOCATION_CHECK_CACHING_DURATION);
    }

    @Nonnull
    @ReturnsMutableCopy
    public TrustedCACertificates getAllTrustedAPCertificates() {
        return new TrustedCACertificates(this.m_aTrustedCAs);
    }

    @Nonnull
    public RevocationCheckResultCache getRevocationCache() {
        return this.m_aRevocationCache;
    }

    @Nonnull
    public ECertificateCheckResult checkCertificate(@Nullable X509Certificate x509Certificate) {
        return this.checkCertificate(x509Certificate, null);
    }

    @Nonnull
    public ECertificateCheckResult checkCertificate(@Nullable X509Certificate x509Certificate, @Nullable OffsetDateTime offsetDateTime) {
        return this.checkCertificate(x509Certificate, offsetDateTime, ETriState.UNDEFINED, null);
    }

    @Nonnull
    public ECertificateCheckResult checkCertificate(@Nullable X509Certificate x509Certificate, @Nullable OffsetDateTime offsetDateTime, @Nonnull ETriState eTriState, @Nullable ERevocationCheckMode eRevocationCheckMode) {
        boolean bl = eTriState.isUndefined() ? CertificateRevocationCheckerDefaults.isCacheRevocationCheckResults() : eTriState.isTrue();
        return CertificateHelper.checkCertificate(this.m_aTrustedCAs.getAllTrustedCAIssuers(), bl && offsetDateTime == null ? this.m_aRevocationCache : null, ((RevocationCheckBuilder)((RevocationCheckBuilder)((RevocationCheckBuilder)new RevocationCheckBuilder().certificate(x509Certificate)).checkDate(offsetDateTime)).validCAs((Iterable<? extends X509Certificate>)this.m_aTrustedCAs.getAllTrustedCACertificates())).checkMode(eRevocationCheckMode));
    }

    public String toString() {
        return new ToStringGenerator(null).append("TrustedCAs", (Object)this.m_aTrustedCAs).append("RevocationCache", (Object)this.m_aRevocationCache).getToString();
    }
}

