/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import jakarta.annotation.Nonnull;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public interface IKeyStoreType
extends IHasID<String> {
    @Nonnull
    default public KeyStore getKeyStore() throws KeyStoreException {
        return KeyStore.getInstance((String)this.getID());
    }

    default public boolean isKeyStorePathRequired() {
        return true;
    }

    @Nonnull
    default public KeyStore getKeyStore(@Nonnull @Nonempty String string) throws KeyStoreException, NoSuchProviderException {
        return KeyStore.getInstance((String)this.getID(), string);
    }

    @Nonnull
    default public KeyStore getKeyStore(@Nonnull Provider provider) throws KeyStoreException {
        return KeyStore.getInstance((String)this.getID(), provider);
    }
}

