/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.peppolid.IIdentifier;
import com.helger.url.codec.URLCoder;
import com.helger.xsds.bdxr.smp1.ParticipantIdentifierType;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import com.helger.xsds.peppol.id1.DocumentIdentifierType;
import com.helger.xsds.peppol.id1.ProcessIdentifierType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class CIdentifier {
    public static final String DEFAULT_PROCESS_IDENTIFIER_NOPROCESS = "busdox:noprocess";
    public static final String URL_SCHEME_VALUE_SEPARATOR = "::";
    private static final CIdentifier INSTANCE = new CIdentifier();

    private CIdentifier() {
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull IIdentifier iIdentifier) {
        return CIdentifier.getURIEncoded(iIdentifier.getScheme(), iIdentifier.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull com.helger.xsds.peppol.id1.ParticipantIdentifierType participantIdentifierType) {
        return CIdentifier.getURIEncoded(participantIdentifierType.getScheme(), participantIdentifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull DocumentIdentifierType documentIdentifierType) {
        return CIdentifier.getURIEncoded(documentIdentifierType.getScheme(), documentIdentifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull ProcessIdentifierType processIdentifierType) {
        return CIdentifier.getURIEncoded(processIdentifierType.getScheme(), processIdentifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull ParticipantIdentifierType participantIdentifierType) {
        return CIdentifier.getURIEncoded(participantIdentifierType.getScheme(), participantIdentifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull com.helger.xsds.bdxr.smp1.DocumentIdentifierType documentIdentifierType) {
        return CIdentifier.getURIEncoded(documentIdentifierType.getScheme(), documentIdentifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull com.helger.xsds.bdxr.smp1.ProcessIdentifierType processIdentifierType) {
        return CIdentifier.getURIEncoded(processIdentifierType.getScheme(), processIdentifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull IdentifierType identifierType) {
        return CIdentifier.getURIEncoded(identifierType.getSchemeID(), identifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nullable String string, @Nullable String string2) {
        String string3 = StringHelper.getNotNull((String)string);
        String string4 = StringHelper.getNotNull((String)string2);
        return string3 + URL_SCHEME_VALUE_SEPARATOR + string4;
    }

    @Nonnull
    @Nonempty
    public static String getURIEncodedBDXR2(@Nullable String string, @Nullable String string2) {
        String string3 = StringHelper.getNotNull((String)string);
        String string4 = StringHelper.getNotNull((String)string2);
        if (StringHelper.isNotEmpty((String)string3)) {
            return string3 + URL_SCHEME_VALUE_SEPARATOR + string4;
        }
        return string4;
    }

    @Nullable
    public static String createPercentEncoded(@Nullable String string) {
        return string == null ? null : URLCoder.urlEncode((String)string);
    }

    @Nullable
    public static String createPercentDecoded(@Nullable String string) {
        return URLCoder.urlDecodeOrNull((String)string);
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nonnull IIdentifier iIdentifier) {
        return CIdentifier.getURIPercentEncoded(iIdentifier.getScheme(), iIdentifier.getValue());
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nonnull com.helger.xsds.peppol.id1.ParticipantIdentifierType participantIdentifierType) {
        return CIdentifier.getURIPercentEncoded(participantIdentifierType.getScheme(), participantIdentifierType.getValue());
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nonnull DocumentIdentifierType documentIdentifierType) {
        return CIdentifier.getURIPercentEncoded(documentIdentifierType.getScheme(), documentIdentifierType.getValue());
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nonnull ProcessIdentifierType processIdentifierType) {
        return CIdentifier.getURIPercentEncoded(processIdentifierType.getScheme(), processIdentifierType.getValue());
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nonnull ParticipantIdentifierType participantIdentifierType) {
        return CIdentifier.getURIPercentEncoded(participantIdentifierType.getScheme(), participantIdentifierType.getValue());
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nonnull com.helger.xsds.bdxr.smp1.DocumentIdentifierType documentIdentifierType) {
        return CIdentifier.getURIPercentEncoded(documentIdentifierType.getScheme(), documentIdentifierType.getValue());
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nonnull com.helger.xsds.bdxr.smp1.ProcessIdentifierType processIdentifierType) {
        return CIdentifier.getURIPercentEncoded(processIdentifierType.getScheme(), processIdentifierType.getValue());
    }

    @Nonnull
    @Nonempty
    public static String getURIPercentEncoded(@Nonnull IdentifierType identifierType) {
        return CIdentifier.getURIPercentEncoded(identifierType.getSchemeID(), identifierType.getValue());
    }

    @Nonnull
    public static String getURIPercentEncoded(@Nullable String string, @Nullable String string2) {
        String string3 = CIdentifier.getURIEncoded(string, string2);
        return CIdentifier.createPercentEncoded(string3);
    }
}

