/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.backend.csv;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.commons.csv.CSVReader;
import com.helger.commons.csv.CSVWriter;
import com.helger.config.IConfig;
import com.helger.datetime.format.PDTFromString;
import com.helger.io.file.FileHelper;
import com.helger.peppol.reporting.api.EReportingDirection;
import com.helger.peppol.reporting.api.PeppolReportingHelper;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.api.backend.IPeppolReportingBackendSPI;
import com.helger.peppol.reporting.api.backend.PeppolReportingBackendException;
import com.helger.peppolid.CIdentifier;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IsSPIImplementation
public class PeppolReportingBackendCSVSPI
implements IPeppolReportingBackendSPI {
    public static final String CONFIG_PEPPOL_REPORTING_CSV_FILENAME = "peppol.reporting.csv.filename";
    public static final String CONFIG_PEPPOL_REPORTING_CSV_SEPARATOR_CHAR = "peppol.reporting.csv.separator-char";
    public static final String CONFIG_PEPPOL_REPORTING_CSV_QUOTE_CHAR = "peppol.reporting.csv.quote-char";
    public static final String CONFIG_PEPPOL_REPORTING_CSV_ESCAPE_CHAR = "peppol.reporting.csv.escape-char";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportingBackendCSVSPI.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private File m_aCSVFile;
    private char m_cSeparatorChar;
    private char m_cQuoteChar;
    private char m_cEscapeChar;
    @GuardedBy(value="m_aRWLock")
    private CSVWriter m_aCSVWriter;

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return "CSV";
    }

    private static char _asChar(@Nonnull IConfig iConfig, String string, char c) {
        String string2 = iConfig.getAsString((Object)string);
        if (StringHelper.isEmpty((String)string2)) {
            return c;
        }
        if (string2.length() > 1) {
            LOGGER.warn("The configuration property '" + string + "' value length of " + string2.length() + " is stripped to the first character");
        }
        return string2.charAt(0);
    }

    @Nonnull
    public ESuccess initBackend(@Nonnull IConfig iConfig) {
        String string = iConfig.getAsString((Object)CONFIG_PEPPOL_REPORTING_CSV_FILENAME);
        if (StringHelper.isEmpty((String)string)) {
            LOGGER.error("The CSV filename is missing in the configuration. See property 'peppol.reporting.csv.filename'");
            return ESuccess.FAILURE;
        }
        File file = new File(string);
        if (!FileHelper.canReadAndWriteFile((File)file)) {
            LOGGER.error("The CSV filename '" + string + "' is missing the necessary access rights to read and write");
            return ESuccess.FAILURE;
        }
        this.m_cSeparatorChar = PeppolReportingBackendCSVSPI._asChar(iConfig, CONFIG_PEPPOL_REPORTING_CSV_SEPARATOR_CHAR, ',');
        this.m_cQuoteChar = PeppolReportingBackendCSVSPI._asChar(iConfig, CONFIG_PEPPOL_REPORTING_CSV_QUOTE_CHAR, '\"');
        this.m_cEscapeChar = PeppolReportingBackendCSVSPI._asChar(iConfig, CONFIG_PEPPOL_REPORTING_CSV_ESCAPE_CHAR, '\\');
        this.m_aRWLock.writeLocked(() -> {
            this.m_aCSVFile = file;
            try {
                this.m_aCSVWriter = new CSVWriter((Writer)new FileWriter(file, StandardCharsets.UTF_8, true));
                this.m_aCSVWriter.setSeparatorChar(this.m_cSeparatorChar).setQuoteChar(this.m_cQuoteChar).setEscapeChar(this.m_cEscapeChar);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Failed to create CSV Writer", iOException);
            }
        });
        if (!this.isInitialized()) {
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    public boolean isInitialized() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aCSVWriter != null);
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _shutdown() {
        this.m_aCSVFile = null;
        try {
            this.m_aCSVWriter.close();
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to close the CSV Writer", (Throwable)iOException);
        }
        this.m_aCSVWriter = null;
    }

    public void shutdownBackend() {
        if (this.isInitialized()) {
            this.m_aRWLock.writeLocked(() -> {
                LOGGER.info("Shutting down Peppol Reporting CSV client");
                this._shutdown();
            });
        } else {
            LOGGER.warn("The Peppol Reporting CSV backend cannot be shutdown, because it was never properly initialized");
        }
    }

    @Nonnull
    static ICommonsList<String> asCSV(@Nonnull PeppolReportingItem peppolReportingItem) {
        ValueEnforcer.notNull((Object)peppolReportingItem, (String)"Value");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        commonsArrayList.add((Object)DateTimeFormatter.ISO_DATE_TIME.format(peppolReportingItem.getExchangeDTUTC()));
        commonsArrayList.add((Object)DateTimeFormatter.ISO_LOCAL_DATE.format(peppolReportingItem.getExchangeDTUTC().toLocalDate()));
        commonsArrayList.add((Object)peppolReportingItem.getDirection().getID());
        commonsArrayList.add((Object)peppolReportingItem.getC2ID());
        commonsArrayList.add((Object)peppolReportingItem.getC3ID());
        commonsArrayList.add((Object)peppolReportingItem.getDocTypeIDScheme());
        commonsArrayList.add((Object)peppolReportingItem.getDocTypeIDValue());
        commonsArrayList.add((Object)peppolReportingItem.getProcessIDScheme());
        commonsArrayList.add((Object)peppolReportingItem.getProcessIDValue());
        commonsArrayList.add((Object)peppolReportingItem.getTransportProtocol());
        commonsArrayList.add((Object)peppolReportingItem.getC1CountryCode());
        if (peppolReportingItem.hasC4CountryCode()) {
            commonsArrayList.add((Object)peppolReportingItem.getC4CountryCode());
        } else {
            commonsArrayList.add(null);
        }
        commonsArrayList.add((Object)peppolReportingItem.getEndUserID());
        return commonsArrayList;
    }

    @Nonnull
    private String _getCSVFilename() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_aCSVFile == null ? "" : this.m_aCSVFile.getAbsolutePath());
    }

    public void storeReportingItem(@Nonnull PeppolReportingItem peppolReportingItem) throws PeppolReportingBackendException {
        ValueEnforcer.notNull((Object)peppolReportingItem, (String)"ReportingItem");
        String string = this._getCSVFilename();
        if (PeppolReportingHelper.isDocumentTypeEligableForReporting((String)peppolReportingItem.getDocTypeIDScheme(), (String)peppolReportingItem.getDocTypeIDValue())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to store Peppol Reporting Item in CSV '" + string + "'");
            }
            if (!this.isInitialized()) {
                throw new IllegalStateException("The Peppol Reporting CSV backend '" + string + "' is not initialized");
            }
            this.m_aRWLock.writeLockedThrowing(() -> {
                this.m_aCSVWriter.writeNext(PeppolReportingBackendCSVSPI.asCSV(peppolReportingItem));
                try {
                    this.m_aCSVWriter.flush();
                }
                catch (IOException iOException) {
                    throw new PeppolReportingBackendException("Failed to flush CSV file '" + string + "'", (Exception)iOException);
                }
            });
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully stored Peppol Reporting Item in CSV '" + string + "'");
            }
        } else {
            LOGGER.info("Not storing Peppol Reporting Item in CSV '" + string + "', as the document type is not eligable for reporting (" + CIdentifier.getURIEncoded((String)peppolReportingItem.getDocTypeIDScheme(), (String)peppolReportingItem.getDocTypeIDValue()) + ")");
        }
    }

    @Nonnull
    static PeppolReportingItem asItem(@Nonnull ICommonsList<String> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"Value");
        return PeppolReportingItem.builder().exchangeDateTime(PDTFromString.getOffsetDateTimeFromString((String)((String)iCommonsList.get(0)), (DateTimeFormatter)DateTimeFormatter.ISO_DATE_TIME)).direction(EReportingDirection.getFromIDOrThrow((String)((String)iCommonsList.get(2)))).c2ID((String)iCommonsList.get(3)).c3ID((String)iCommonsList.get(4)).docTypeIDScheme((String)iCommonsList.get(5)).docTypeIDValue((String)iCommonsList.get(6)).processIDScheme((String)iCommonsList.get(7)).processIDValue((String)iCommonsList.get(8)).transportProtocol((String)iCommonsList.get(9)).c1CountryCode((String)iCommonsList.get(10)).c4CountryCode(StringHelper.getNotEmpty((String)((String)iCommonsList.get(11)), (String)null)).endUserID((String)iCommonsList.get(12)).build();
    }

    public void forEachReportingItem(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2, @Nonnull Consumer<? super PeppolReportingItem> consumer) throws PeppolReportingBackendException {
        ValueEnforcer.notNull((Object)localDate, (String)"StartDateIncl");
        ValueEnforcer.notNull((Object)localDate2, (String)"EndDateIncl");
        ValueEnforcer.isTrue(() -> localDate2.compareTo(localDate) >= 0, (String)"EndDateIncl must be >= StartDateIncl");
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        String string = this._getCSVFilename();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Querying Peppol Reporting Items from CSV '" + string + "' between " + String.valueOf(localDate) + " and " + String.valueOf(localDate2));
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("The Peppol Reporting CSV backend '" + string + "' is not initialized");
        }
        try (CSVReader cSVReader = new CSVReader((Reader)new FileReader(this.m_aCSVFile, StandardCharsets.UTF_8));){
            ICommonsList iCommonsList;
            cSVReader.setSeparatorChar(this.m_cSeparatorChar).setQuoteChar(this.m_cQuoteChar).setEscapeChar(this.m_cEscapeChar);
            while ((iCommonsList = cSVReader.readNext()) != null) {
                LocalDate localDate3 = PDTFromString.getLocalDateFromString((String)((String)iCommonsList.get(1)), (DateTimeFormatter)DateTimeFormatter.ISO_LOCAL_DATE);
                if (localDate3.compareTo(localDate) < 0 || localDate3.compareTo(localDate2) > 0) continue;
                PeppolReportingItem peppolReportingItem = PeppolReportingBackendCSVSPI.asItem((ICommonsList<String>)iCommonsList);
                consumer.accept((PeppolReportingItem)peppolReportingItem);
            }
        }
        catch (IOException iOException) {
            throw new PeppolReportingBackendException("IO error in reading CSV '" + string + "'", (Exception)iOException);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found a total of 0 matching documents in CSV '" + string + "'");
        }
    }

    @Nonnull
    public Iterable<PeppolReportingItem> iterateReportingItems(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) throws PeppolReportingBackendException {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.forEachReportingItem(localDate, localDate2, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }
}

