/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.file;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.peppol.reportingsupport.IPeppolReportStorage;
import com.helger.peppol.reportingsupport.domain.PeppolReportData;
import com.helger.peppol.reportingsupport.domain.PeppolReportSendingReportData;
import com.helger.peppol.reportingsupport.file.IPeppolReportStorageFilenameProvider;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroWriter;
import jakarta.annotation.Nonnull;
import java.io.File;

public class PeppolReportStorageFileXML
implements IPeppolReportStorage {
    private final File m_aBaseDir;
    private final IPeppolReportStorageFilenameProvider m_aFilenameProvider;

    public PeppolReportStorageFileXML(@Nonnull File file, @Nonnull IPeppolReportStorageFilenameProvider iPeppolReportStorageFilenameProvider) {
        ValueEnforcer.notNull((Object)file, (String)"BaseDir");
        ValueEnforcer.notNull((Object)iPeppolReportStorageFilenameProvider, (String)"FilenameProvider");
        this.m_aBaseDir = file;
        this.m_aFilenameProvider = iPeppolReportStorageFilenameProvider;
    }

    @Override
    @Nonnull
    public ESuccess storePeppolReport(@Nonnull PeppolReportData peppolReportData) {
        MicroDocument microDocument = new MicroDocument();
        microDocument.addChild((IMicroNode)peppolReportData.getAsMicroElement(null, "PeppolReportData"));
        File file = new File(this.m_aBaseDir, this.m_aFilenameProvider.getFilename(peppolReportData.getReportPeriod(), peppolReportData.getReportType(), peppolReportData.getReportCreationDT(), "peppol-report.xml"));
        return MicroWriter.writeToFile((IMicroNode)microDocument, (File)file);
    }

    @Override
    @Nonnull
    public ESuccess storePeppolReportingSendingReport(@Nonnull PeppolReportSendingReportData peppolReportSendingReportData) {
        MicroDocument microDocument = new MicroDocument();
        microDocument.addChild((IMicroNode)peppolReportSendingReportData.getAsMicroElement(null, "SendingReportData"));
        File file = new File(this.m_aBaseDir, this.m_aFilenameProvider.getFilename(peppolReportSendingReportData.getReportPeriod(), peppolReportSendingReportData.getReportType(), peppolReportSendingReportData.getReportCreationDT(), "sending-report.xml"));
        return MicroWriter.writeToFile((IMicroNode)microDocument, (File)file);
    }
}

