/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.mongodb;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.config.IConfig;
import com.helger.peppol.reporting.backend.mongodb.MongoClientWrapper;
import com.helger.peppol.reporting.backend.mongodb.PeppolReportingBackendMongoDBSPI;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Supplier;

public class PeppolReportMongoDBHandler
implements Supplier<MongoClientWrapper>,
AutoCloseable {
    private MongoClientWrapper m_aMongoDBClient;

    protected PeppolReportMongoDBHandler(@Nullable MongoClientWrapper mongoClientWrapper) {
        this.m_aMongoDBClient = mongoClientWrapper;
    }

    @Override
    public void close() {
        if (this.m_aMongoDBClient != null) {
            this.m_aMongoDBClient.close();
            this.m_aMongoDBClient = null;
        }
    }

    @Override
    @Nullable
    public MongoClientWrapper get() {
        return this.m_aMongoDBClient;
    }

    @Nonnull
    public static PeppolReportMongoDBHandler createPeppolReportingConfigured(@Nonnull IConfig iConfig) {
        ValueEnforcer.notNull((Object)iConfig, (String)"Config");
        return new PeppolReportMongoDBHandler(PeppolReportingBackendMongoDBSPI.createDefaultClientWrapper((IConfig)iConfig));
    }

    @Nonnull
    public static PeppolReportMongoDBHandler create(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ConnectionString");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DBName");
        return new PeppolReportMongoDBHandler(new MongoClientWrapper(string, string2));
    }
}

