/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.sql;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.db.api.EDatabaseSystemType;
import com.helger.db.api.config.IJdbcConfiguration;
import com.helger.db.api.flyway.FlywayConfiguration;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.BaseCallback;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.jdbc.DriverDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PeppolReportFlywayMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Singleton.class);

    private PeppolReportFlywayMigrator() {
    }

    void runFlyway(@Nonnull EDatabaseSystemType eDatabaseSystemType, @Nonnull IJdbcConfiguration iJdbcConfiguration, @Nonnull FlywayConfiguration flywayConfiguration) {
        ValueEnforcer.notNull((Object)eDatabaseSystemType, (String)"DBType");
        ValueEnforcer.notNull((Object)iJdbcConfiguration, (String)"JdbcConfig");
        ValueEnforcer.notNull((Object)flywayConfiguration, (String)"FlywayConfig");
        LOGGER.info("Starting to run Flyway for DB type " + String.valueOf(eDatabaseSystemType));
        BaseCallback baseCallback = new BaseCallback(){

            public void handle(@Nonnull Event event, @Nullable Context context) {
                ResolvedMigration resolvedMigration;
                MigrationInfo migrationInfo;
                LOGGER.info("Flyway: Event " + event.getId());
                if (event == Event.AFTER_EACH_MIGRATE && context != null && (migrationInfo = context.getMigrationInfo()) instanceof MigrationInfoImpl && (resolvedMigration = ((MigrationInfoImpl)migrationInfo).getResolvedMigration()) != null) {
                    LOGGER.info("  Performed migration: " + String.valueOf(resolvedMigration));
                }
            }
        };
        BaseCallback baseCallback2 = new BaseCallback(){

            public void handle(@Nonnull Event event, @Nullable Context context) {
                ResolvedMigration resolvedMigration;
                MigrationInfo migrationInfo;
                if (event == Event.AFTER_EACH_MIGRATE && context != null && (migrationInfo = context.getMigrationInfo()) instanceof MigrationInfoImpl && (resolvedMigration = ((MigrationInfoImpl)migrationInfo).getResolvedMigration()) != null && resolvedMigration.getVersion().isAtLeast("7")) {
                    LOGGER.info("  SQL Migration success: " + resolvedMigration.getVersion().toString() + " / " + resolvedMigration.getDescription() + " / " + resolvedMigration.getScript() + " / " + resolvedMigration.getType().name() + " / " + resolvedMigration.getPhysicalLocation());
                }
            }
        };
        FluentConfiguration fluentConfiguration = Flyway.configure().dataSource((DataSource)new DriverDataSource(PeppolReportFlywayMigrator.class.getClassLoader(), iJdbcConfiguration.getJdbcDriver(), flywayConfiguration.getFlywayJdbcUrl(), flywayConfiguration.getFlywayJdbcUser(), flywayConfiguration.getFlywayJdbcPassword()));
        fluentConfiguration.baselineOnMigrate(true);
        fluentConfiguration.validateOnMigrate(false);
        fluentConfiguration.baselineVersion(Integer.toString(flywayConfiguration.getFlywayBaselineVersion())).baselineDescription("Peppol Report Storage Baseline");
        fluentConfiguration.locations(new String[]{"db/peppol-report-" + eDatabaseSystemType.getID()});
        fluentConfiguration.callbacks(new Callback[]{baseCallback, baseCallback2});
        String string = iJdbcConfiguration.getJdbcSchema();
        if (StringHelper.isNotEmpty((String)string)) {
            fluentConfiguration.schemas(new String[]{string});
        }
        fluentConfiguration.createSchemas(flywayConfiguration.isFlywaySchemaCreate());
        Flyway flyway = fluentConfiguration.load();
        flyway.migrate();
        LOGGER.info("Finished running Flyway");
    }

    @Immutable
    public static final class Singleton {
        static final PeppolReportFlywayMigrator INSTANCE = new PeppolReportFlywayMigrator();

        private Singleton() {
        }
    }
}

