/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.text.TextFormatter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EPeppolSBDHDataError implements IHasID<String>
{
    INVALID_SBD_XML("invalid-sbd-xml", "Failed to interpret StandardBusinessDocument as XML."),
    MISSING_SBDH("missing-sbdh", "The ''StandardBusinessDocumentHeader'' element is not present."),
    INVALID_HEADER_VERSION("invalid-header-version", "The ''HeaderVersion'' element has the illegal value ''{0}''."),
    INVALID_SENDER_COUNT("invalid-sender-count", "Not exactly one ''Sender'' element is present but {0}."),
    INVALID_SENDER_AUTHORITY("invalid-sender-authority", "The ''Sender/Identifier/Authority'' attribute has the invalid value ''{0}''."),
    INVALID_SENDER_VALUE("invalid-sender-value", "The ''Sender/Identifier'' has the invalid value ''{0}''."),
    INVALID_RECEIVER_COUNT("invalid-receiver-count", "Not exactly one ''Receiver'' element is present but {0}."),
    INVALID_RECEIVER_AUTHORITY("invalid-receiver-authority", "The ''Receiver/Identifier/Authority'' attribute has the invalid value ''{0}''."),
    INVALID_RECEIVER_VALUE("invalid-receiver-value", "The ''Receiver/Identifier'' has the invalid value ''{0}''."),
    BUSINESS_SCOPE_MISSING("business-scope-missing", "The ''BusinessScope'' element is missing."),
    INVALID_SCOPE_COUNT("invalid-scope-count", "At least {0} ''BusinessScope/Scope'' elements must be present but found {1}."),
    INVALID_DOCUMENT_TYPE_IDENTIFIER("invalid-document-type-identifier", "The provided document type identifier ''{0}'' is invalid according to the defined rules."),
    INVALID_PROCESS_IDENTIFIER("invalid-process-identifier", "The provided process identifier ''{0}'' is invalid according to the defined rules."),
    INVALID_COUNTRY_C1("invalid-country-c1", "The provided C1 country code ''{0}'' is invalid according to the defined rules."),
    INVALID_MLS_TO("invalid-mls-to", "The provided MLS addressee ''{0}::{1}'' is invalid according to the defined rules."),
    INVALID_MLS_TYPE("invalid-mls-type", "The provided MLS type ''{0}'' is invalid according to the defined rules."),
    MISSING_DOCUMENT_TYPE_IDENTIFIER("missing-document-type-identifier", "The document type identifier is missing."),
    MISSING_PROCESS_IDENTIFIER("missing-process-identifier", "The process identifier is missing."),
    MISSING_COUNTRY_C1("missing-country-c1", "The C1 country code is missing."),
    INVALID_BUSINESS_MESSAGE("invalid-business-message", "The main business message is invalid according to the defined rules."),
    INVALID_STANDARD("invalid-standard", "The ''DocumentIdentification/Standard'' element has the illegal value ''{0}''. It must equal the namespace URI of the business message (''{1}''). It must also be the beginning of the document type identifier value (''{2}'')."),
    INVALID_TYPE_VERSION("invalid-type-version", "The ''DocumentIdentification/TypeVersion'' element has the invalid value ''{0}''. It may not contain a colon character and it must be the end of the document type identifier value (''{1}'')."),
    INVALID_TYPE("invalid-type", "The ''DocumentIdentification/Type''  element has the invalid value ''{0}''. It must match the local name of the root element of the business message (''{1}'')."),
    INVALID_INSTANCE_IDENTIFIER("invalid-instance-identifier", "The ''DocumentIdentification/InstanceIdentifier'' element has the invalid value ''{0}'' according to the defined rules."),
    INVALID_CREATION_DATE_TIME("invalid-creation-date-time", "The ''DocumentIdentification/CreationDateAndTime'' element has the invalid value ''{0}'' according to the defined rules."),
    GENERIC_SBDH_ERROR("generic-sbdh-error", "A generic error occurred.");

    private final String m_sID;
    private final String m_sErrorMsg;

    private EPeppolSBDHDataError(String string2, String string3) {
        this.m_sID = string2;
        this.m_sErrorMsg = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage() {
        return this.m_sErrorMsg;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage(Object ... objectArray) {
        return TextFormatter.getFormattedText((String)this.m_sErrorMsg, (Object[])objectArray);
    }

    @Nullable
    public static EPeppolSBDHDataError getFromIDOrNull(@Nullable String string) {
        return (EPeppolSBDHDataError)EnumHelper.getFromIDOrNull(EPeppolSBDHDataError.class, (Object)string);
    }

    @Nullable
    public static EPeppolSBDHDataError getFromIDOrDefault(@Nullable String string, @Nullable EPeppolSBDHDataError ePeppolSBDHDataError) {
        return (EPeppolSBDHDataError)EnumHelper.getFromIDOrDefault(EPeppolSBDHDataError.class, (Object)string, (Enum)ePeppolSBDHDataError);
    }
}

