/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.jaxb.adapter.JAXBHelper;
import com.helger.mime.IMimeType;
import com.helger.peppol.sbdh.EPeppolMLSType;
import com.helger.peppol.sbdh.PeppolSBDHAdditionalAttributes;
import com.helger.peppol.sbdh.PeppolSBDHDataWriter;
import com.helger.peppol.sbdh.payload.PeppolSBDHPayloadBinaryMarshaller;
import com.helger.peppol.sbdh.payload.PeppolSBDHPayloadTextMarshaller;
import com.helger.peppol.sbdh.spec12.BinaryContentType;
import com.helger.peppol.sbdh.spec12.ObjectFactory;
import com.helger.peppol.sbdh.spec12.TextContentType;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.typeconvert.collection.StringMap;
import com.helger.xml.XMLHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
public class PeppolSBDHData {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolSBDHData.class);
    private final IIdentifierFactory m_aIdentifierFactory;
    private String m_sSenderScheme;
    private String m_sSenderValue;
    private String m_sReceiverScheme;
    private String m_sReceiverValue;
    private String m_sDocumentTypeScheme;
    private String m_sDocumentTypeValue;
    private String m_sProcessScheme;
    private String m_sProcessValue;
    private String m_sCountryC1;
    private String m_sMLSToScheme;
    private String m_sMLSToValue;
    private EPeppolMLSType m_eMLSType;
    private String m_sStandard;
    private String m_sTypeVersion;
    private String m_sType;
    private String m_sInstanceIdentifier;
    private XMLOffsetDateTime m_aCreationDateAndTime;
    private Element m_aBusinessMessage;
    private final StringMap m_aAdditionalAttrs = new StringMap();

    public PeppolSBDHData(@Nonnull IIdentifierFactory iIdentifierFactory) {
        this.m_aIdentifierFactory = (IIdentifierFactory)ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
    }

    @Nullable
    public String getSenderScheme() {
        return this.m_sSenderScheme;
    }

    @Nullable
    public String getSenderValue() {
        return this.m_sSenderValue;
    }

    @Nullable
    public IParticipantIdentifier getSenderAsIdentifier() {
        return this.m_aIdentifierFactory.createParticipantIdentifier(this.m_sSenderScheme, this.m_sSenderValue);
    }

    @Nonnull
    public PeppolSBDHData setSender(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_sSenderScheme = string;
        this.m_sSenderValue = string2;
        return this;
    }

    @Nonnull
    public PeppolSBDHData setSender(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"SenderID");
        return this.setSender(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @Nonnull
    public PeppolSBDHData setSenderWithDefaultScheme(@Nonnull @Nonempty String string) {
        return this.setSender("iso6523-actorid-upis", string);
    }

    @Nullable
    public String getReceiverScheme() {
        return this.m_sReceiverScheme;
    }

    @Nullable
    public String getReceiverValue() {
        return this.m_sReceiverValue;
    }

    @Nullable
    public IParticipantIdentifier getReceiverAsIdentifier() {
        return this.m_aIdentifierFactory.createParticipantIdentifier(this.m_sReceiverScheme, this.m_sReceiverValue);
    }

    @Nonnull
    public PeppolSBDHData setReceiver(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_sReceiverScheme = string;
        this.m_sReceiverValue = string2;
        return this;
    }

    @Nonnull
    public PeppolSBDHData setReceiver(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ReceiverID");
        return this.setReceiver(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @Nonnull
    public PeppolSBDHData setReceiverWithDefaultScheme(@Nonnull @Nonempty String string) {
        return this.setReceiver("iso6523-actorid-upis", string);
    }

    @Nullable
    public String getDocumentTypeScheme() {
        return this.m_sDocumentTypeScheme;
    }

    @Nullable
    public String getDocumentTypeValue() {
        return this.m_sDocumentTypeValue;
    }

    @Nullable
    public IDocumentTypeIdentifier getDocumentTypeAsIdentifier() {
        return this.m_aIdentifierFactory.createDocumentTypeIdentifier(this.m_sDocumentTypeScheme, this.m_sDocumentTypeValue);
    }

    @Nonnull
    public PeppolSBDHData setDocumentType(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_sDocumentTypeScheme = string;
        this.m_sDocumentTypeValue = string2;
        return this;
    }

    @Nonnull
    public PeppolSBDHData setDocumentType(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        return this.setDocumentType(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue());
    }

    @Nonnull
    public PeppolSBDHData setDocumentTypeWithBusdoxDocidQns(@Nonnull @Nonempty String string) {
        return this.setDocumentType("busdox-docid-qns", string);
    }

    @Nonnull
    public PeppolSBDHData setDocumentTypeWithPeppolDoctypeWildcard(@Nonnull @Nonempty String string) {
        return this.setDocumentType("peppol-doctype-wildcard", string);
    }

    @Nullable
    public String getProcessScheme() {
        return this.m_sProcessScheme;
    }

    @Nullable
    public String getProcessValue() {
        return this.m_sProcessValue;
    }

    @Nullable
    public IProcessIdentifier getProcessAsIdentifier() {
        return this.m_aIdentifierFactory.createProcessIdentifier(this.m_sProcessScheme, this.m_sProcessValue);
    }

    @Nonnull
    public PeppolSBDHData setProcess(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_sProcessScheme = string;
        this.m_sProcessValue = string2;
        return this;
    }

    @Nonnull
    public PeppolSBDHData setProcess(@Nonnull IProcessIdentifier iProcessIdentifier) {
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        return this.setProcess(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue());
    }

    @Nonnull
    public PeppolSBDHData setProcessWithDefaultScheme(@Nonnull @Nonempty String string) {
        return this.setProcess("cenbii-procid-ubl", string);
    }

    @Nullable
    public String getCountryC1() {
        return this.m_sCountryC1;
    }

    public boolean hasCountryC1() {
        return StringHelper.isNotEmpty((String)this.m_sCountryC1);
    }

    @Nonnull
    public PeppolSBDHData setCountryC1(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CountryC1");
        this.m_sCountryC1 = string;
        return this;
    }

    @Nullable
    public String getMLSToScheme() {
        return this.m_sMLSToScheme;
    }

    public boolean hasMLSToScheme() {
        return StringHelper.isNotEmpty((String)this.m_sMLSToScheme);
    }

    @Nonnull
    public PeppolSBDHData setMLSToScheme(@Nullable String string) {
        this.m_sMLSToScheme = string;
        return this;
    }

    @Nullable
    public String getMLSToValue() {
        return this.m_sMLSToValue;
    }

    public boolean hasMLSToValue() {
        return StringHelper.isNotEmpty((String)this.m_sMLSToValue);
    }

    @Nonnull
    public PeppolSBDHData setMLSToValue(@Nullable String string) {
        this.m_sMLSToValue = string;
        return this;
    }

    @Nullable
    public EPeppolMLSType getMLSType() {
        return this.m_eMLSType;
    }

    public boolean hasMLSType() {
        return this.m_eMLSType != null;
    }

    @Nonnull
    public PeppolSBDHData setMLSType(@Nullable EPeppolMLSType ePeppolMLSType) {
        this.m_eMLSType = ePeppolMLSType;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public StringMap additionalAttributes() {
        return this.m_aAdditionalAttrs;
    }

    @Nonnull
    public PeppolSBDHData setDocumentIdentification(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        this.setStandard(string);
        this.setTypeVersion(string2);
        this.setType(string3);
        this.setInstanceIdentifier(string4);
        this.setCreationDateAndTime(xMLOffsetDateTime);
        return this;
    }

    @Nullable
    public String getStandard() {
        return this.m_sStandard;
    }

    public boolean hasStandard() {
        return StringHelper.isNotEmpty((String)this.m_sStandard);
    }

    @Nonnull
    public PeppolSBDHData setStandard(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Standard");
        this.m_sStandard = string;
        return this;
    }

    @Nullable
    public String getTypeVersion() {
        return this.m_sTypeVersion;
    }

    public boolean hasTypeVersion() {
        return StringHelper.isNotEmpty((String)this.m_sTypeVersion);
    }

    @Nonnull
    public PeppolSBDHData setTypeVersion(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TypeVersion");
        this.m_sTypeVersion = string;
        return this;
    }

    @Nullable
    public String getType() {
        return this.m_sType;
    }

    public boolean hasType() {
        return StringHelper.isNotEmpty((String)this.m_sType);
    }

    @Nonnull
    public PeppolSBDHData setType(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Type");
        this.m_sType = string;
        return this;
    }

    @Nullable
    public String getInstanceIdentifier() {
        return this.m_sInstanceIdentifier;
    }

    public boolean hasInstanceIdentifier() {
        return StringHelper.isNotEmpty((String)this.m_sInstanceIdentifier);
    }

    @Nonnull
    public PeppolSBDHData setInstanceIdentifier(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"InstanceIdentifier");
        this.m_sInstanceIdentifier = string;
        return this;
    }

    @Nullable
    public XMLOffsetDateTime getCreationDateAndTime() {
        return this.m_aCreationDateAndTime;
    }

    public boolean hasCreationDateAndTime() {
        return this.m_aCreationDateAndTime != null;
    }

    @Nonnull
    public PeppolSBDHData setCreationDateAndTime(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        ValueEnforcer.notNull((Object)xMLOffsetDateTime, (String)"CreationDateAndTime");
        this.m_aCreationDateAndTime = PDTFactory.getWithMillisOnly((XMLOffsetDateTime)xMLOffsetDateTime);
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public Element getBusinessMessage() {
        return this.m_aBusinessMessage == null ? null : (Element)this.m_aBusinessMessage.cloneNode(true);
    }

    @Nullable
    @ReturnsMutableObject
    public Element getBusinessMessageNoClone() {
        return this.m_aBusinessMessage;
    }

    public boolean isNonXMLPayload() {
        return PeppolSBDHData.isNonXMLSBDHPayload(this.m_aBusinessMessage);
    }

    public boolean hasBusinessMessage() {
        return this.m_aBusinessMessage != null;
    }

    @Nullable
    public BinaryContentType getBusinessMessageAsBinaryContent() {
        if (this.m_aBusinessMessage == null) {
            return null;
        }
        if (!"BinaryContent".equals(XMLHelper.getLocalNameOrTagName((Element)this.m_aBusinessMessage))) {
            return null;
        }
        return (BinaryContentType)new PeppolSBDHPayloadBinaryMarshaller().read(this.m_aBusinessMessage);
    }

    @Nullable
    public TextContentType getBusinessMessageAsTextContent() {
        if (this.m_aBusinessMessage == null) {
            return null;
        }
        if (!"TextContent".equals(XMLHelper.getLocalNameOrTagName((Element)this.m_aBusinessMessage))) {
            return null;
        }
        return (TextContentType)new PeppolSBDHPayloadTextMarshaller().read(this.m_aBusinessMessage);
    }

    @Nonnull
    public PeppolSBDHData setBusinessMessage(@Nonnull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        this.m_aBusinessMessage = (Element)element.cloneNode(true);
        return this;
    }

    @Nonnull
    public PeppolSBDHData setBusinessMessageNoClone(@Nonnull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        this.m_aBusinessMessage = element;
        return this;
    }

    @Nonnull
    public PeppolSBDHData setBusinessMessageBinaryOnly(@Nonnull byte[] byArray, @Nonnull IMimeType iMimeType, @Nullable Charset charset) {
        ValueEnforcer.notNull((Object)byArray, (String)"BinaryPayload");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        BinaryContentType binaryContentType = new BinaryContentType();
        binaryContentType.setValue(byArray);
        binaryContentType.setMimeType(iMimeType.getAsString());
        binaryContentType.setEncoding(charset == null ? null : charset.name());
        this.m_aBusinessMessage = new PeppolSBDHPayloadBinaryMarshaller().getAsElement(binaryContentType);
        if (this.m_aBusinessMessage == null) {
            throw new IllegalStateException("Failed to create 'BinaryContent' element.");
        }
        return this;
    }

    @Nonnull
    public PeppolSBDHData setBusinessMessageTextOnly(@Nonnull String string, @Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)string, (String)"TextPayload");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        TextContentType textContentType = new TextContentType();
        textContentType.setValue(string);
        textContentType.setMimeType(iMimeType.getAsString());
        this.m_aBusinessMessage = new PeppolSBDHPayloadTextMarshaller().getAsElement(textContentType);
        if (this.m_aBusinessMessage == null) {
            throw new IllegalStateException("Failed to create 'TextContent' element.");
        }
        return this;
    }

    public boolean areAllFieldsSet(boolean bl) {
        return this.areAllFieldsSet(bl ? arg_0 -> ((Logger)LOGGER).info(arg_0) : string -> {});
    }

    public boolean areAllFieldsSet(@Nonnull Consumer<String> consumer) {
        ValueEnforcer.notNull(consumer, (String)"MissingFieldConsumer");
        int n = 0;
        if (StringHelper.isEmpty((String)this.m_sSenderScheme)) {
            consumer.accept("Peppol SBDH data - Sender Scheme is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sSenderValue)) {
            consumer.accept("Peppol SBDH data - Sender Value is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sReceiverScheme)) {
            consumer.accept("Peppol SBDH data - Receiver Scheme is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sReceiverValue)) {
            consumer.accept("Peppol SBDH data - Reeiver Value is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sDocumentTypeScheme)) {
            consumer.accept("Peppol SBDH data - Document Type ID Scheme is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sDocumentTypeValue)) {
            consumer.accept("Peppol SBDH data - Document Type ID Value is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sProcessScheme)) {
            consumer.accept("Peppol SBDH data - Process ID Scheme is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sProcessValue)) {
            consumer.accept("Peppol SBDH data - Process ID Value is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sCountryC1)) {
            consumer.accept("Peppol SBDH data - Country C1 is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sStandard)) {
            consumer.accept("Peppol SBDH data - Standard is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sTypeVersion)) {
            consumer.accept("Peppol SBDH data - Type Version is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sType)) {
            consumer.accept("Peppol SBDH data - Type is missing");
            ++n;
        }
        if (StringHelper.isEmpty((String)this.m_sInstanceIdentifier)) {
            consumer.accept("Peppol SBDH data - Instance Identifier is missing");
            ++n;
        }
        if (this.m_aCreationDateAndTime == null) {
            consumer.accept("Peppol SBDH data - Creation Date and Time is missing");
            ++n;
        }
        if (this.m_aBusinessMessage == null) {
            consumer.accept("Peppol SBDH data - Business Message is missing");
            ++n;
        }
        return n == 0;
    }

    public boolean areAllFieldsSet() {
        return this.areAllFieldsSet(false);
    }

    public boolean areAllAdditionalAttributesValid() {
        if (this.m_aAdditionalAttrs.isNotEmpty()) {
            for (String string : this.m_aAdditionalAttrs.keySet()) {
                if (!PeppolSBDHAdditionalAttributes.isReservedAttributeName(string)) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public StandardBusinessDocument getAsStandardBusinessDocument() {
        return new PeppolSBDHDataWriter().createStandardBusinessDocument(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PeppolSBDHData peppolSBDHData = (PeppolSBDHData)object;
        return EqualsHelper.equals((Object)this.m_sSenderScheme, (Object)peppolSBDHData.m_sSenderScheme) && EqualsHelper.equals((Object)this.m_sSenderValue, (Object)peppolSBDHData.m_sSenderValue) && EqualsHelper.equals((Object)this.m_sReceiverScheme, (Object)peppolSBDHData.m_sReceiverScheme) && EqualsHelper.equals((Object)this.m_sReceiverValue, (Object)peppolSBDHData.m_sReceiverValue) && EqualsHelper.equals((Object)this.m_sDocumentTypeScheme, (Object)peppolSBDHData.m_sDocumentTypeScheme) && EqualsHelper.equals((Object)this.m_sDocumentTypeValue, (Object)peppolSBDHData.m_sDocumentTypeValue) && EqualsHelper.equals((Object)this.m_sProcessScheme, (Object)peppolSBDHData.m_sProcessScheme) && EqualsHelper.equals((Object)this.m_sProcessValue, (Object)peppolSBDHData.m_sProcessValue) && EqualsHelper.equals((Object)this.m_sCountryC1, (Object)peppolSBDHData.m_sCountryC1) && EqualsHelper.equals((Object)this.m_sMLSToScheme, (Object)peppolSBDHData.m_sMLSToScheme) && EqualsHelper.equals((Object)this.m_sMLSToValue, (Object)peppolSBDHData.m_sMLSToValue) && EqualsHelper.equals((Object)((Object)this.m_eMLSType), (Object)((Object)peppolSBDHData.m_eMLSType)) && EqualsHelper.equals((Object)this.m_sStandard, (Object)peppolSBDHData.m_sStandard) && EqualsHelper.equals((Object)this.m_sTypeVersion, (Object)peppolSBDHData.m_sTypeVersion) && EqualsHelper.equals((Object)this.m_sType, (Object)peppolSBDHData.m_sType) && EqualsHelper.equals((Object)this.m_sInstanceIdentifier, (Object)peppolSBDHData.m_sInstanceIdentifier) && EqualsHelper.equals((Object)this.m_aCreationDateAndTime, (Object)peppolSBDHData.m_aCreationDateAndTime) && JAXBHelper.equalDOMNodes((Node)this.m_aBusinessMessage, (Node)peppolSBDHData.m_aBusinessMessage) && this.m_aAdditionalAttrs.equals((Object)peppolSBDHData.m_aAdditionalAttrs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sSenderScheme).append((Object)this.m_sSenderValue).append((Object)this.m_sReceiverScheme).append((Object)this.m_sReceiverValue).append((Object)this.m_sDocumentTypeScheme).append((Object)this.m_sDocumentTypeValue).append((Object)this.m_sProcessScheme).append((Object)this.m_sProcessValue).append((Object)this.m_sCountryC1).append((Object)this.m_sMLSToScheme).append((Object)this.m_sMLSToValue).append((Object)this.m_eMLSType).append((Object)this.m_sStandard).append((Object)this.m_sTypeVersion).append((Object)this.m_sType).append((Object)this.m_sInstanceIdentifier).append((Object)this.m_aCreationDateAndTime).append(JAXBHelper.getHashCode((Node)this.m_aBusinessMessage)).append((Object)this.m_aAdditionalAttrs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SenderScheme", (Object)this.m_sSenderScheme).append("SenderValue", (Object)this.m_sSenderValue).append("ReceiverScheme", (Object)this.m_sReceiverScheme).append("ReceiverValue", (Object)this.m_sReceiverValue).append("DocumentTypeScheme", (Object)this.m_sDocumentTypeScheme).append("DocumentTypeValue", (Object)this.m_sDocumentTypeValue).append("ProcessScheme", (Object)this.m_sProcessScheme).append("ProcessValue", (Object)this.m_sProcessValue).append("CountryC1", (Object)this.m_sCountryC1).append("MLSToScheme", (Object)this.m_sMLSToScheme).append("MLSToValue", (Object)this.m_sMLSToValue).append("MLSType", (Enum)this.m_eMLSType).append("Standard", (Object)this.m_sStandard).append("TypeVersion", (Object)this.m_sTypeVersion).append("Type", (Object)this.m_sType).append("InstanceIdentifier", (Object)this.m_sInstanceIdentifier).append("CreationDateAndTime", (Object)this.m_aCreationDateAndTime).append("BusinessMessage", (Object)this.m_aBusinessMessage).append("AdditionalAttributes", (Object)this.m_aAdditionalAttrs).getToString();
    }

    private static boolean _hasQName(@Nonnull QName qName, @Nonnull Element element) {
        return qName.getNamespaceURI().equals(element.getNamespaceURI()) && qName.getLocalPart().equals(element.getLocalName());
    }

    public static boolean isNonXMLSBDHPayload(@Nullable Element element) {
        return element != null && PeppolSBDHData._hasQName(ObjectFactory._BinaryContent_QNAME, element) || PeppolSBDHData._hasQName(ObjectFactory._TextContent_QNAME, element);
    }

    @Nonnull
    public static PeppolSBDHData createUBL21(@Nonnull Element element, @Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        PeppolSBDHData peppolSBDHData = new PeppolSBDHData(iIdentifierFactory);
        peppolSBDHData.setBusinessMessage(element);
        peppolSBDHData.setDocumentIdentification(element.getNamespaceURI(), "2.1", element.getLocalName(), UUID.randomUUID().toString(), PDTFactory.getCurrentXMLOffsetDateTimeMillisOnly());
        return peppolSBDHData;
    }
}

