/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr1;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr1.IBDXRServiceGroupProvider;
import com.helger.smpclient.bdxr1.IBDXRServiceMetadataProvider;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerServiceGroupType;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerSignedServiceMetadataType;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.httpclient.AbstractGenericSMPClient;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.smpclient.redirect.ISMPFollowRedirectCallback;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ParticipantIdentifierType;
import com.helger.xsds.bdxr.smp1.ProcessIdentifierType;
import com.helger.xsds.bdxr.smp1.ProcessType;
import com.helger.xsds.bdxr.smp1.ServiceGroupType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataReferenceType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import com.helger.xsds.bdxr.smp1.SignedServiceMetadataType;
import com.helger.xsds.xmldsig.X509DataType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBElement;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXRClientReadOnly
extends AbstractGenericSMPClient<BDXRClientReadOnly>
implements IBDXRServiceGroupProvider,
IBDXRServiceMetadataProvider {
    public static final String URL_PART_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXRClientReadOnly.class);

    public BDXRClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public BDXRClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public BDXRClientReadOnly(@Nonnull URI uRI) {
        super(uRI, false);
    }

    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        BDXR1MarshallerServiceGroupType bDXR1MarshallerServiceGroupType = new BDXR1MarshallerServiceGroupType();
        bDXR1MarshallerServiceGroupType.setUseSchema(this.isXMLSchemaValidation());
        this.customizeMarshaller(bDXR1MarshallerServiceGroupType);
        ServiceGroupType serviceGroupType = this.executeGenericRequest((HttpUriRequestBase)httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupType>(bDXR1MarshallerServiceGroupType));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + String.valueOf(serviceGroupType));
        }
        return serviceGroupType;
    }

    @Override
    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceGroup");
            }
            return null;
        }
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType, @Nonnull IIdentifierFactory iIdentifierFactory, @Nullable Consumer<String> consumer) {
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (serviceGroupType != null && serviceGroupType.getParticipantIdentifier() != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
            String string = "/" + CIdentifier.getURIEncoded((ParticipantIdentifierType)serviceGroupType.getParticipantIdentifier()) + "/services/";
            for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                String string2;
                IDocumentTypeIdentifier iDocumentTypeIdentifier;
                String string3 = serviceMetadataReferenceType.getHref();
                String string4 = CIdentifier.createPercentDecoded((String)string3);
                boolean bl = false;
                int n = StringHelper.getIndexOfIgnoreCase((String)string4, (String)string, (Locale)Locale.US);
                if (n >= 0 && (iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier(string2 = string4.substring(n + string.length()))) != null) {
                    commonsArrayList.add((Object)iDocumentTypeIdentifier);
                    bl = true;
                }
                if (bl || consumer == null) continue;
                consumer.accept(string3);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public SignedServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier, null);
    }

    @Nonnull
    public SignedServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable ISMPFollowRedirectCallback iSMPFollowRedirectCallback) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient getServiceRegistration@" + string);
        }
        boolean bl = this.isXMLSchemaValidation();
        boolean bl2 = this.isVerifySignature();
        boolean bl3 = this.isSecureValidation();
        KeyStore keyStore = this.getTrustStore();
        if (bl2 && keyStore == null) {
            LOGGER.error("BDXR SMP client Verify Signature is enabled, but no TrustStore is provided. This will not work.");
        }
        HttpGet httpGet = new HttpGet(string);
        BDXR1MarshallerSignedServiceMetadataType bDXR1MarshallerSignedServiceMetadataType = new BDXR1MarshallerSignedServiceMetadataType();
        bDXR1MarshallerSignedServiceMetadataType.setUseSchema(bl);
        this.customizeMarshaller(bDXR1MarshallerSignedServiceMetadataType);
        HttpGet httpGet2 = new SMPHttpResponseHandlerSigned(bDXR1MarshallerSignedServiceMetadataType, keyStore);
        httpGet2.setVerifySignature(bl2);
        httpGet2.setSecureValidation(bl3);
        SignedServiceMetadataType signedServiceMetadataType = this.executeGenericRequest((HttpUriRequestBase)httpGet, httpGet2);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + String.valueOf(signedServiceMetadataType));
        }
        if (signedServiceMetadataType.getServiceMetadata() != null && signedServiceMetadataType.getServiceMetadata().getRedirect() != null) {
            httpGet = signedServiceMetadataType.getServiceMetadata().getRedirect();
            boolean bl4 = this.isFollowSMPRedirects();
            if (iSMPFollowRedirectCallback != null) {
                iSMPFollowRedirectCallback.onFollowSMPRedirect(bl4, httpGet.getHref());
            }
            if (bl4) {
                LOGGER.info("Following a redirect from '" + string + "' to '" + httpGet.getHref() + "'");
                httpGet2 = new HttpGet(httpGet.getHref());
                BDXR1MarshallerSignedServiceMetadataType bDXR1MarshallerSignedServiceMetadataType2 = new BDXR1MarshallerSignedServiceMetadataType();
                bDXR1MarshallerSignedServiceMetadataType2.setUseSchema(bl);
                this.customizeMarshaller(bDXR1MarshallerSignedServiceMetadataType2);
                SMPHttpResponseHandlerSigned<SignedServiceMetadataType> sMPHttpResponseHandlerSigned = new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>(bDXR1MarshallerSignedServiceMetadataType2, keyStore);
                sMPHttpResponseHandlerSigned.setVerifySignature(bl2);
                sMPHttpResponseHandlerSigned.setSecureValidation(bl3);
                signedServiceMetadataType = this.executeGenericRequest((HttpUriRequestBase)httpGet2, sMPHttpResponseHandlerSigned);
                boolean bl5 = false;
                for (Object e : signedServiceMetadataType.getSignature().getKeyInfo().getContent()) {
                    X509DataType x509DataType;
                    Object object;
                    if (!(e instanceof JAXBElement) || !((object = ((JAXBElement)e).getValue()) instanceof X509DataType) || !BDXRClientReadOnly.containsRedirectSubject(x509DataType = (X509DataType)object, httpGet.getCertificateUID())) continue;
                    bl5 = true;
                    break;
                }
                if (!bl5) {
                    throw new SMPClientException("The X509 certificate did not contain a certificate subject.");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Following SMP redirects is disabled");
            }
        }
        return signedServiceMetadataType;
    }

    @Override
    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable ISMPFollowRedirectCallback iSMPFollowRedirectCallback) throws SMPClientException {
        try {
            return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier, iSMPFollowRedirectCallback);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceMetadata");
            }
            return null;
        }
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)signedServiceMetadataType, (String)"SignedServiceMetadata");
        return BDXRClientReadOnly.getEndpoint(signedServiceMetadataType.getServiceMetadata(), iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"ServiceMetadata");
        ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
        if (serviceInformationType == null) {
            return null;
        }
        ValueEnforcer.notNull((Object)serviceInformationType.getProcessList(), (String)"ServiceMetadata.ServiceInformation.ProcessList");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
            if (!SimpleProcessIdentifier.wrap((ProcessIdentifierType)processType.getProcessIdentifier()).hasSameContent(iProcessIdentifier)) continue;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                if (!iSMPTransportProfile.getID().equals(endpointType.getTransportProfile())) continue;
                commonsArrayList.add((Object)endpointType);
            }
            if (commonsArrayList.size() != 1) {
                LOGGER.warn("Found " + commonsArrayList.size() + " endpoints for process " + String.valueOf(iProcessIdentifier) + " and transport profile " + iSMPTransportProfile.getID() + (String)(commonsArrayList.isEmpty() ? "" : ": " + commonsArrayList.toString() + " - using the first one"));
            }
            EndpointType endpointType = (EndpointType)commonsArrayList.getFirstOrNull();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found matching endpoint: " + String.valueOf(endpointType));
            }
            return endpointType;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found no matching SMP endpoint");
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getEndpointURI();
    }

    @Nullable
    public static byte[] getEndpointCertificateBytes(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getCertificate();
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        byte[] byArray = BDXRClientReadOnly.getEndpointCertificateBytes(endpointType);
        return CertificateHelper.convertByteArrayToCertficateDirect((byte[])byArray);
    }

    @Nullable
    public static X509Certificate getEndpointCertificateOrNull(@Nullable EndpointType endpointType) {
        try {
            return BDXRClientReadOnly.getEndpointCertificate(endpointType);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new BDXRClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static SignedServiceMetadataType getServiceRegistrationByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new BDXRClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

