/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.HttpClientSettings;
import com.helger.jaxb.GenericJAXBMarshaller;
import com.helger.mime.CMimeType;
import com.helger.security.certificate.CertificateHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.smpclient.config.SMPClientConfiguration;
import com.helger.smpclient.exception.SMPClientBadRequestException;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.exception.SMPClientParticipantNotFoundException;
import com.helger.smpclient.exception.SMPClientUnauthorizedException;
import com.helger.smpclient.httpclient.SMPHttpClientSettings;
import com.helger.xsds.xmldsig.X509DataType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericSMPClient<IMPLTYPE extends AbstractGenericSMPClient<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    public static final boolean DEFAULT_XML_SCHEMA_VALIDATION = true;
    public static final ContentType CONTENT_TYPE_TEXT_XML = ContentType.create((String)CMimeType.TEXT_XML.getAsString(), (Charset)StandardCharsets.UTF_8);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGenericSMPClient.class);
    private static final KeyStore DEFAULT_TRUST_STORE;
    private final String m_sSMPHost;
    private boolean m_bVerifySignature = true;
    private boolean m_bSecureValidation = true;
    private KeyStore m_aTrustStore = DEFAULT_TRUST_STORE;
    private boolean m_bFollowSMPRedirects = true;
    private boolean m_bXMLSchemaValidation = true;
    private final SMPHttpClientSettings m_aHttpClientSettings = new SMPHttpClientSettings();
    private Consumer<? super GenericJAXBMarshaller<?>> m_aMarshallerConsumer;

    protected AbstractGenericSMPClient(@Nonnull URI uRI, boolean bl) {
        String string;
        ValueEnforcer.notNull((Object)uRI, (String)"SMPHost");
        if (bl) {
            if (!"http".equals(uRI.getScheme())) {
                LOGGER.warn("SMP URI " + String.valueOf(uRI) + " does not use the expected http scheme, which is required for Peppol!");
            }
            if (uRI.getPort() != 80 && uRI.getPort() != -1) {
                LOGGER.warn("SMP URI " + String.valueOf(uRI) + " is not running on port 80, which is required for Peppol!");
            }
        }
        this.m_sSMPHost = (string = uRI.toString()).endsWith("/") ? string : string + "/";
    }

    @Nonnull
    public final String getSMPHostURI() {
        return this.m_sSMPHost;
    }

    @Nonnull
    @ReturnsMutableObject
    public final SMPHttpClientSettings httpClientSettings() {
        return this.m_aHttpClientSettings;
    }

    @Nonnull
    public final IMPLTYPE withHttpClientSettings(@Nonnull Consumer<? super SMPHttpClientSettings> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        consumer.accept(this.m_aHttpClientSettings);
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public final boolean isVerifySignature() {
        return this.m_bVerifySignature;
    }

    @Nonnull
    public final IMPLTYPE setVerifySignature(boolean bl) {
        this.m_bVerifySignature = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public final boolean isSecureValidation() {
        return this.m_bSecureValidation;
    }

    @Nonnull
    public final IMPLTYPE setSecureValidation(boolean bl) {
        this.m_bSecureValidation = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nullable
    public final KeyStore getTrustStore() {
        return this.m_aTrustStore;
    }

    @Nonnull
    public final IMPLTYPE setTrustStore(@Nullable KeyStore keyStore) {
        this.m_aTrustStore = keyStore;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public final boolean isFollowSMPRedirects() {
        return this.m_bFollowSMPRedirects;
    }

    @Nonnull
    public final IMPLTYPE setFollowSMPRedirects(boolean bl) {
        this.m_bFollowSMPRedirects = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public final boolean isXMLSchemaValidation() {
        return this.m_bXMLSchemaValidation;
    }

    @Nonnull
    public final IMPLTYPE setXMLSchemaValidation(boolean bl) {
        this.m_bXMLSchemaValidation = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nonnull
    @OverrideOnDemand
    protected HttpClientContext createHttpContext() {
        return HttpClientContext.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public <T> T executeRequest(@Nonnull HttpUriRequestBase httpUriRequestBase, @Nonnull HttpClientResponseHandler<T> httpClientResponseHandler) throws IOException {
        HttpClientContext httpClientContext = this.createHttpContext();
        try (HttpClientManager httpClientManager = HttpClientManager.create((HttpClientSettings)this.m_aHttpClientSettings);){
            httpUriRequestBase.setAbsoluteRequestUri(true);
            LOGGER.info("Performing SMP query at '" + httpUriRequestBase.toString() + "'");
            Object object = httpClientManager.execute((ClassicHttpRequest)httpUriRequestBase, (HttpContext)httpClientContext, httpClientResponseHandler);
            return (T)object;
        }
        catch (IOException | RuntimeException exception) {
            if (GlobalDebug.isDebugMode()) {
                LOGGER.error("Error performing SMP query [debug full exception]", (Throwable)exception);
                throw exception;
            }
            LOGGER.error("Error performing SMP query: " + exception.getClass().getName() + " - " + exception.getMessage());
            throw exception;
        }
    }

    @Nonnull
    public <T> T executeGenericRequest(@Nonnull HttpUriRequestBase httpUriRequestBase, @Nonnull HttpClientResponseHandler<T> httpClientResponseHandler) throws SMPClientException {
        try {
            return this.executeRequest(httpUriRequestBase, httpClientResponseHandler);
        }
        catch (Exception exception) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exception executing HTTP request " + String.valueOf(httpUriRequestBase), (Throwable)exception);
            }
            throw AbstractGenericSMPClient.getConvertedException(exception);
        }
    }

    @Nonnull
    public static SMPClientException getConvertedException(@Nonnull Exception exception) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converting exception of class '" + exception.getClass().getName() + "' to an SMP expception");
        }
        if (exception instanceof SMPClientException) {
            return (SMPClientException)exception;
        }
        if (exception instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)exception;
            int n = httpResponseException.getStatusCode();
            switch (n) {
                case 400: {
                    return new SMPClientBadRequestException(httpResponseException);
                }
                case 403: {
                    return new SMPClientUnauthorizedException(httpResponseException);
                }
                case 404: {
                    return new SMPClientNotFoundException(httpResponseException);
                }
            }
            return new SMPClientException("Error thrown with HTTP status code " + n, (Throwable)httpResponseException);
        }
        if (exception instanceof UnknownHostException) {
            return new SMPClientParticipantNotFoundException((UnknownHostException)exception);
        }
        if (exception instanceof ConnectException) {
            return new SMPClientParticipantNotFoundException((ConnectException)exception);
        }
        if (exception instanceof ClientProtocolException && exception.getCause() instanceof SMPClientException) {
            return (SMPClientException)exception.getCause();
        }
        return new SMPClientException("Unknown error thrown by SMP server (" + exception.getMessage() + ")", exception);
    }

    protected final void customizeMarshaller(@Nonnull GenericJAXBMarshaller<?> genericJAXBMarshaller) {
        if (this.m_aMarshallerConsumer != null) {
            this.m_aMarshallerConsumer.accept(genericJAXBMarshaller);
        }
    }

    @Nullable
    public final Consumer<? super GenericJAXBMarshaller<?>> getMarshallerCustomizer() {
        return this.m_aMarshallerConsumer;
    }

    @Nonnull
    public final IMPLTYPE setMarshallerCustomizer(@Nullable Consumer<? super GenericJAXBMarshaller<?>> consumer) {
        this.m_aMarshallerConsumer = consumer;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SMPHost", (Object)this.m_sSMPHost).append("VerifySignature", this.m_bVerifySignature).append("TrustStore", (Object)this.m_aTrustStore).append("FollowSMPRedirects", this.m_bFollowSMPRedirects).append("XMLSchemaValidation", this.m_bXMLSchemaValidation).append("HttpClientSettings", (Object)this.m_aHttpClientSettings).appendIfNotNull("MarshallerConsumer", this.m_aMarshallerConsumer).getToString();
    }

    private static boolean _isEqualRdn(String string, String string2) {
        try {
            CommonsHashSet commonsHashSet = new CommonsHashSet(new LdapName(string).getRdns());
            CommonsHashSet commonsHashSet2 = new CommonsHashSet(new LdapName(string2).getRdns());
            return commonsHashSet.equals((Object)commonsHashSet2);
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
    }

    public static boolean containsRedirectSubject(@Nonnull X509DataType x509DataType, @Nonnull String string) throws SMPClientException {
        for (Object e : x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
            if (!(e instanceof JAXBElement)) continue;
            JAXBElement jAXBElement = (JAXBElement)e;
            if ("X509SubjectName".equals(jAXBElement.getName().getLocalPart())) {
                String string2 = (String)jAXBElement.getValue();
                if (!AbstractGenericSMPClient._isEqualRdn(string, string2)) {
                    throw new SMPClientException("The certificate UID of the redirect did not match the certificate subject which is '" + string2 + "'. Required certificate UID is '" + string + "'");
                }
                return true;
            }
            if (!"X509Certificate".equals(jAXBElement.getName().getLocalPart())) continue;
            byte[] byArray = (byte[])jAXBElement.getValue();
            try {
                X509Certificate x509Certificate = CertificateHelper.convertByteArrayToCertficateDirect((byte[])byArray);
                if (x509Certificate != null) {
                    String string3 = x509Certificate.getSubjectX500Principal().getName();
                    if (!AbstractGenericSMPClient._isEqualRdn(string, string3)) {
                        throw new SMPClientException("The certificate UID of the redirect did not match the certificate/subject which '" + string3 + "'. Required certificate UID is '" + string + "'");
                    }
                    return true;
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    static {
        EKeyStoreType eKeyStoreType = SMPClientConfiguration.getTrustStoreType();
        String string = SMPClientConfiguration.getTrustStorePath();
        DEFAULT_TRUST_STORE = SMPClientConfiguration.loadTrustStore();
        if (DEFAULT_TRUST_STORE != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully loaded configured SMP client trust store '" + string + "' of type " + String.valueOf(eKeyStoreType));
            }
        } else if (StringHelper.isEmpty((String)string)) {
            LOGGER.warn("No SMP client trust store is configured");
        } else {
            LOGGER.warn("Failed to load the configured SMP client trust store '" + string + "' of type " + String.valueOf(eKeyStoreType));
        }
    }
}

