/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.peppol.doctype.IPeppolGenericDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.doctype.PeppolGenericDocumentTypeIdentifierParts;
import jakarta.annotation.Nonnull;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class PeppolWildcardSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolWildcardSelector.class);

    private PeppolWildcardSelector() {
    }

    @Nonnull
    public static ESuccess findPeppolDoctypeWildcardMatch(@Nonnull ICommonsList<? extends IDocumentTypeIdentifier> iCommonsList, @Nonnull @Nonempty IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull Consumer<? super IDocumentTypeIdentifier> consumer) {
        ValueEnforcer.notNull(iCommonsList, (String)"BaseDocTypes");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"SearchDocTypeValue");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier.getValue(), (String)"SearchDocTypeValue.Value");
        ValueEnforcer.notNull(consumer, (String)"MatchingDocTypeConsumer");
        BiFunction<String, String, IDocumentTypeIdentifier> biFunction = (string, string2) -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking if document type ID '" + CIdentifier.getURIEncoded((String)string, (String)string2) + "' is contained");
            }
            if (iCommonsList.containsAny(iDocumentTypeIdentifier -> iDocumentTypeIdentifier.hasScheme(string) && iDocumentTypeIdentifier.hasValue(string2))) {
                return PeppolIdentifierFactory.INSTANCE.createDocumentTypeIdentifier(string, string2);
            }
            return null;
        };
        PeppolGenericDocumentTypeIdentifierParts peppolGenericDocumentTypeIdentifierParts = PeppolGenericDocumentTypeIdentifierParts.extractFromString((String)iDocumentTypeIdentifier.getValue());
        Function<String, String> function = arg_0 -> PeppolWildcardSelector.lambda$findPeppolDoctypeWildcardMatch$2((IPeppolGenericDocumentTypeIdentifierParts)peppolGenericDocumentTypeIdentifierParts, arg_0);
        String string3 = StringHelper.trimEnd((String)peppolGenericDocumentTypeIdentifierParts.getCustomizationID(), (char)'*');
        if (string3.indexOf(42) >= 0) {
            LOGGER.error("Customization ID contains a forbidden wildcard indicator: '" + string3 + "'");
            return ESuccess.FAILURE;
        }
        IDocumentTypeIdentifier iDocumentTypeIdentifier2 = biFunction.apply(iDocumentTypeIdentifier.getScheme(), function.apply(string3));
        if (iDocumentTypeIdentifier2 != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found a wildcard exact match: '" + iDocumentTypeIdentifier2.getURIEncoded() + "'");
            }
            consumer.accept((IDocumentTypeIdentifier)iDocumentTypeIdentifier2);
            return ESuccess.SUCCESS;
        }
        iDocumentTypeIdentifier2 = biFunction.apply(iDocumentTypeIdentifier.getScheme(), function.apply(string3 + "*"));
        if (iDocumentTypeIdentifier2 != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found a wildcard best match: '" + iDocumentTypeIdentifier2.getURIEncoded() + "'");
            }
            consumer.accept((IDocumentTypeIdentifier)iDocumentTypeIdentifier2);
            return ESuccess.SUCCESS;
        }
        while (string3.indexOf(64) >= 0) {
            string3 = string3.substring(0, string3.lastIndexOf(64));
            iDocumentTypeIdentifier2 = biFunction.apply(iDocumentTypeIdentifier.getScheme(), function.apply(string3 + "*"));
            if (iDocumentTypeIdentifier2 == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found a wildcard best match: '" + iDocumentTypeIdentifier2.getURIEncoded() + "'");
            }
            consumer.accept((IDocumentTypeIdentifier)iDocumentTypeIdentifier2);
            return ESuccess.SUCCESS;
        }
        return ESuccess.FAILURE;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }

    private static /* synthetic */ String lambda$findPeppolDoctypeWildcardMatch$2(IPeppolGenericDocumentTypeIdentifierParts iPeppolGenericDocumentTypeIdentifierParts, String string) {
        return new PeppolGenericDocumentTypeIdentifierParts(iPeppolGenericDocumentTypeIdentifierParts.getSyntaxSpecificID(), string, iPeppolGenericDocumentTypeIdentifierParts.getVersion()).getAsDocumentTypeIdentifierValue();
    }
}

