/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol.utils;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLFactory;
import com.helger.xml.XMLHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class W3CEndpointReferenceHelper {
    private static final W3CEndpointReferenceHelper INSTANCE = new W3CEndpointReferenceHelper();

    private W3CEndpointReferenceHelper() {
    }

    @Nonnull
    public static W3CEndpointReference createEndpointReference(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Address");
        return new W3CEndpointReferenceBuilder().address(string).build();
    }

    @Nonnull
    public static W3CEndpointReference createEndpointReference(@Nonnull String string, @Nonnull Iterable<Element> iterable) {
        ValueEnforcer.notNull((Object)string, (String)"Address");
        W3CEndpointReferenceBuilder w3CEndpointReferenceBuilder = new W3CEndpointReferenceBuilder().address(string);
        for (Element element : iterable) {
            w3CEndpointReferenceBuilder = w3CEndpointReferenceBuilder.referenceParameter(element);
        }
        return w3CEndpointReferenceBuilder.build();
    }

    @Nonnull
    private static Element _convertReferenceToXML(@Nonnull W3CEndpointReference w3CEndpointReference) {
        Document document = XMLFactory.newDocument();
        DOMResult dOMResult = new DOMResult(document);
        w3CEndpointReference.writeTo((Result)dOMResult);
        return document.getDocumentElement();
    }

    @Nullable
    public static String getAddress(@Nonnull W3CEndpointReference w3CEndpointReference) {
        ValueEnforcer.notNull((Object)w3CEndpointReference, (String)"EndpointReference");
        Element element = XMLHelper.getFirstChildElementOfName((Node)W3CEndpointReferenceHelper._convertReferenceToXML(w3CEndpointReference), (String)"Address");
        return element == null ? null : element.getTextContent();
    }

    @Nullable
    public static ICommonsList<Element> getReferenceParameters(@Nonnull W3CEndpointReference w3CEndpointReference) {
        ValueEnforcer.notNull((Object)w3CEndpointReference, (String)"EndpointReference");
        Element element = XMLHelper.getFirstChildElementOfName((Node)W3CEndpointReferenceHelper._convertReferenceToXML(w3CEndpointReference), (String)"ReferenceParameters");
        if (element == null) {
            return null;
        }
        return new CommonsArrayList((Iterable)new ChildElementIterator((Node)element));
    }

    @Nullable
    public static Element getReferenceParameter(@Nonnull W3CEndpointReference w3CEndpointReference, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)w3CEndpointReference, (String)"EndpointReference");
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ICommonsList<Element> iCommonsList = W3CEndpointReferenceHelper.getReferenceParameters(w3CEndpointReference);
        return iCommonsList == null ? null : (Element)iCommonsList.getAtIndex(n);
    }
}

