/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.url;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URISyntaxException;

public interface IPeppolURLProvider
extends ISMPURLProvider {
    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier var1, @Nullable String var2) throws SMPDNSResolutionException;

    @Nonnull
    default public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        ValueEnforcer.notNull((Object)iSMLInfo, (String)"SMLInfo");
        return this.getDNSNameOfParticipant(iParticipantIdentifier, iSMLInfo.getDNSZone());
    }

    @Override
    @Nonnull
    default public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws SMPDNSResolutionException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        String string2 = "http://" + this.getDNSNameOfParticipant(iParticipantIdentifier, string);
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SMPDNSResolutionException("Error building SMP URI from string '" + string2 + "'", uRISyntaxException);
        }
    }
}

