/*
 * Decompiled with CFR 0.152.
 */
package org.unece.cefact.namespaces.sbdh;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.unece.cefact.namespaces.sbdh.BusinessScope;
import org.unece.cefact.namespaces.sbdh.DocumentIdentification;
import org.unece.cefact.namespaces.sbdh.Manifest;
import org.unece.cefact.namespaces.sbdh.Partner;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StandardBusinessDocumentHeader", propOrder={"headerVersion", "sender", "receiver", "documentIdentification", "manifest", "businessScope"})
@CodingStyleguideUnaware
public class StandardBusinessDocumentHeader
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="HeaderVersion", required=true)
    private String headerVersion;
    @XmlElement(name="Sender", required=true)
    private List<Partner> sender;
    @XmlElement(name="Receiver", required=true)
    private List<Partner> receiver;
    @XmlElement(name="DocumentIdentification", required=true)
    private DocumentIdentification documentIdentification;
    @XmlElement(name="Manifest")
    private Manifest manifest;
    @XmlElement(name="BusinessScope")
    private BusinessScope businessScope;

    @Nullable
    public String getHeaderVersion() {
        return this.headerVersion;
    }

    public void setHeaderVersion(@Nullable String string) {
        this.headerVersion = string;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<Partner> getSender() {
        if (this.sender == null) {
            this.sender = new ArrayList<Partner>();
        }
        return this.sender;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<Partner> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Partner>();
        }
        return this.receiver;
    }

    @Nullable
    public DocumentIdentification getDocumentIdentification() {
        return this.documentIdentification;
    }

    public void setDocumentIdentification(@Nullable DocumentIdentification documentIdentification) {
        this.documentIdentification = documentIdentification;
    }

    @Nullable
    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(@Nullable Manifest manifest) {
        this.manifest = manifest;
    }

    @Nullable
    public BusinessScope getBusinessScope() {
        return this.businessScope;
    }

    public void setBusinessScope(@Nullable BusinessScope businessScope) {
        this.businessScope = businessScope;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StandardBusinessDocumentHeader standardBusinessDocumentHeader = (StandardBusinessDocumentHeader)object;
        if (!EqualsHelper.equals((Object)this.businessScope, (Object)standardBusinessDocumentHeader.businessScope)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.documentIdentification, (Object)standardBusinessDocumentHeader.documentIdentification)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.headerVersion, (Object)standardBusinessDocumentHeader.headerVersion)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.manifest, (Object)standardBusinessDocumentHeader.manifest)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.receiver, standardBusinessDocumentHeader.receiver)) {
            return false;
        }
        return EqualsHelper.equalsCollection(this.sender, standardBusinessDocumentHeader.sender);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.businessScope).append((Object)this.documentIdentification).append((Object)this.headerVersion).append((Object)this.manifest).append(this.receiver).append(this.sender).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("businessScope", (Object)this.businessScope).append("documentIdentification", (Object)this.documentIdentification).append("headerVersion", (Object)this.headerVersion).append("manifest", (Object)this.manifest).append("receiver", this.receiver).append("sender", this.sender).getToString();
    }

    public void setSender(@Nullable List<Partner> list) {
        this.sender = list;
    }

    public void setReceiver(@Nullable List<Partner> list) {
        this.receiver = list;
    }

    public boolean hasSenderEntries() {
        return !this.getSender().isEmpty();
    }

    public boolean hasNoSenderEntries() {
        return this.getSender().isEmpty();
    }

    @Nonnegative
    public int getSenderCount() {
        return this.getSender().size();
    }

    @Nullable
    public Partner getSenderAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getSender().get(n);
    }

    public void addSender(@Nonnull Partner partner) {
        this.getSender().add(partner);
    }

    public boolean hasReceiverEntries() {
        return !this.getReceiver().isEmpty();
    }

    public boolean hasNoReceiverEntries() {
        return this.getReceiver().isEmpty();
    }

    @Nonnegative
    public int getReceiverCount() {
        return this.getReceiver().size();
    }

    @Nullable
    public Partner getReceiverAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getReceiver().get(n);
    }

    public void addReceiver(@Nonnull Partner partner) {
        this.getReceiver().add(partner);
    }

    public void cloneTo(@Nonnull StandardBusinessDocumentHeader standardBusinessDocumentHeader) {
        ArrayList<Partner> arrayList;
        standardBusinessDocumentHeader.businessScope = this.businessScope == null ? null : this.businessScope.clone();
        standardBusinessDocumentHeader.documentIdentification = this.documentIdentification == null ? null : this.documentIdentification.clone();
        standardBusinessDocumentHeader.headerVersion = this.headerVersion;
        Manifest manifest = standardBusinessDocumentHeader.manifest = this.manifest == null ? null : this.manifest.clone();
        if (this.receiver == null) {
            standardBusinessDocumentHeader.receiver = null;
        } else {
            arrayList = new ArrayList<Partner>();
            for (Partner partner : this.getReceiver()) {
                arrayList.add(partner == null ? null : partner.clone());
            }
            standardBusinessDocumentHeader.receiver = arrayList;
        }
        if (this.sender == null) {
            standardBusinessDocumentHeader.sender = null;
        } else {
            arrayList = new ArrayList();
            for (Partner partner : this.getSender()) {
                arrayList.add(partner == null ? null : partner.clone());
            }
            standardBusinessDocumentHeader.sender = arrayList;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public StandardBusinessDocumentHeader clone() {
        StandardBusinessDocumentHeader standardBusinessDocumentHeader = new StandardBusinessDocumentHeader();
        this.cloneTo(standardBusinessDocumentHeader);
        return standardBusinessDocumentHeader;
    }
}

