/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.rules.api;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.helper.PDTFactory;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.diver.api.version.DVRVersionException;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.executorset.status.EValidationExecutorStatusType;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.api.executorset.status.ValidationExecutorSetStatus;
import com.helger.phive.xml.schematron.SchematronNamespaceBeautifier;
import com.helger.phive.xml.schematron.ValidationExecutorSchematron;
import com.helger.xml.namespace.IIterableNamespaceContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;

@Immutable
public final class PhiveRulesHelper {
    private PhiveRulesHelper() {
    }

    @Nonnull
    public static DVRCoordinate createCoordinate(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        return PhiveRulesHelper.createCoordinate(string, string2, string3, null);
    }

    @Nonnull
    public static DVRCoordinate createCoordinate(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4) {
        try {
            return DVRCoordinate.create((String)string, (String)string2, (String)string3, (String)string4);
        }
        catch (DVRVersionException dVRVersionException) {
            throw new IllegalArgumentException(dVRVersionException);
        }
    }

    @Nonnull
    public static ValidationExecutorSchematron createXSLT(@Nonnull IReadableResource iReadableResource, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        SchematronNamespaceBeautifier.addMappings((IIterableNamespaceContext)iIterableNamespaceContext);
        return ValidationExecutorSchematron.createXSLT((IReadableResource)iReadableResource, null, (IIterableNamespaceContext)iIterableNamespaceContext);
    }

    @Nonnull
    public static IValidationExecutorSetStatus createSimpleStatus(boolean bl) {
        return ValidationExecutorSetStatus.createDeprecatedNow((boolean)bl);
    }

    @Nonnull
    public static IValidationExecutorSetStatus createSimpleStatus(boolean bl, @Nonnull OffsetDateTime offsetDateTime) {
        return new ValidationExecutorSetStatus(PDTFactory.getCurrentOffsetDateTime(), bl ? EValidationExecutorStatusType.DEPRECATED : EValidationExecutorStatusType.VALID, offsetDateTime, (OffsetDateTime)null, (String)null, (DVRCoordinate)null, (ICommonsList)null);
    }
}

