/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.base.array.ArrayHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.trait.IAddableByTrait;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.typeconvert.TypeConverterException;
import com.helger.typeconvert.impl.TypeConverter;
import java.util.function.BiFunction;

@FunctionalInterface
public interface IAuditActionStringProvider
extends BiFunction<String, Object[], String> {
    public static final IAuditActionStringProvider PLAIN_STRING = (string, objectArray) -> {
        if (ArrayHelper.isEmpty((Object[])objectArray)) {
            return string;
        }
        return string + "(" + StringImplode.getImploded((char)',', (Object[])objectArray) + ")";
    };
    public static final IAuditActionStringProvider JSON = (string, objectArray) -> {
        IJsonArray iJsonArray = (IJsonArray)new JsonArray().addAll(objectArray);
        return new JsonObject().add(string, (IJson)iJsonArray).getAsJsonString();
    };
    public static final IAuditActionStringProvider JSON_WITH_CONVERSION = (string, objectArray) -> {
        JsonArray jsonArray = new JsonArray();
        for (Object object : objectArray) {
            IJson iJson = null;
            try {
                iJson = (IJson)TypeConverter.convert((Object)object, IJson.class);
            }
            catch (TypeConverterException typeConverterException) {
                // empty catch block
            }
            if (iJson != null) {
                jsonArray.add((IAddableByTrait)iJson);
                continue;
            }
            jsonArray.add(object);
        }
        return new JsonObject().add(string, (IJson)jsonArray).getAsJsonString();
    };
}

