/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.state.ESuccess;
import com.helger.base.state.ISuccessIndicator;
import com.helger.photon.audit.EAuditActionType;
import com.helger.security.authentication.subject.user.IHasUserID;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.LocalDateTime;

@MustImplementEqualsAndHashcode
public interface IAuditItem
extends IHasUserID,
ISuccessIndicator,
Serializable {
    @Nonnull
    public LocalDateTime getDateTime();

    @Nonnull
    public EAuditActionType getType();

    @Nonnull
    @Nonempty
    default public String getTypeID() {
        return this.getType().getID();
    }

    @Nonnull
    public ESuccess getSuccess();

    default public boolean isSuccess() {
        return this.getSuccess().isSuccess();
    }

    @Nonnull
    public String getAction();
}

