/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.binding.xpath.PSXPathVariables;
import com.helger.schematron.pure.bound.AbstractPSBoundSchema;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundPattern;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.validation.SchematronValidationException;
import com.helger.schematron.pure.xpath.IXPathConfig;
import com.helger.schematron.pure.xpath.XPathConfigBuilder;
import com.helger.schematron.pure.xpath.XPathEvaluationHelper;
import com.helger.schematron.pure.xpath.XPathLetVariableResolver;
import com.helger.schematron.saxon.SaxonNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.xpath.XPathHelper;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.SourceLocator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.xpath.XPathEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NotThreadSafe
public class PSXPathBoundSchema
extends AbstractPSBoundSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSXPathBoundSchema.class);
    private final IXPathConfig m_aXPathConfig;
    private final XPathLetVariableResolver m_aXPathVariableResolver;
    private ICommonsList<PSXPathBoundPattern> m_aBoundPatterns;
    private PSXPathVariables m_aSchemaVariables;
    private int m_nVarForNodeLists = 0;
    private int m_nVarForString = 0;
    private int m_nVarForBoolean = 0;
    private int m_nVarForNumber = 0;
    private int m_nVarForNode = 0;

    @Nullable
    private static XPathExpression _compileXPath(@Nonnull XPath xPath, @Nonnull String string) throws XPathExpressionException {
        return xPath.compile(string);
    }

    @Nullable
    private ICommonsList<PSXPathBoundElement> _createBoundElements(@Nonnull IPSHasMixedContent iPSHasMixedContent, @Nonnull XPath xPath) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = false;
        for (Object e : iPSHasMixedContent.getAllContentElements()) {
            XPathExpression xPathExpression;
            String string;
            IPSClonableElement<PSName> iPSClonableElement;
            if (e instanceof PSName) {
                iPSClonableElement = (PSName)e;
                if (((PSName)iPSClonableElement).hasPath()) {
                    string = ((PSName)iPSClonableElement).getPath();
                    try {
                        xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                        commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.error(iPSClonableElement, "Failed to compile XPath expression in <name>: '" + string + "'", xPathExpressionException);
                        bl = true;
                    }
                    continue;
                }
                commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement));
                continue;
            }
            if (e instanceof PSValueOf) {
                iPSClonableElement = (PSValueOf)e;
                string = ((PSValueOf)iPSClonableElement).getSelect();
                try {
                    xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                    commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(iPSClonableElement, "Failed to compile XPath expression in <value-of>: '" + string + "'", xPathExpressionException);
                    bl = true;
                }
                continue;
            }
            if (e instanceof String) {
                commonsArrayList.add((Object)new PSXPathBoundElement((String)e));
                continue;
            }
            commonsArrayList.add((Object)new PSXPathBoundElement((IPSElement)e));
        }
        if (bl) {
            return null;
        }
        return commonsArrayList;
    }

    @Nullable
    private ICommonsMap<String, PSXPathBoundDiagnostic> _createBoundDiagnostics(@Nonnull XPath xPath) {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        boolean bl = false;
        PSSchema pSSchema = this.getOriginalSchema();
        if (pSSchema.hasDiagnostics()) {
            for (PSDiagnostic pSDiagnostic : pSSchema.getDiagnostics().getAllDiagnostics()) {
                ICommonsList<PSXPathBoundElement> iCommonsList = this._createBoundElements(pSDiagnostic, xPath);
                if (iCommonsList == null) {
                    bl = true;
                    continue;
                }
                PSXPathBoundDiagnostic pSXPathBoundDiagnostic = new PSXPathBoundDiagnostic(pSDiagnostic, iCommonsList);
                if (commonsHashMap.put((Object)pSDiagnostic.getID(), (Object)pSXPathBoundDiagnostic) == null) continue;
                this.error(pSDiagnostic, "A diagnostic element with ID '" + pSDiagnostic.getID() + "' was overwritten!");
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return commonsHashMap;
    }

    @Nullable
    private ICommonsList<PSXPathBoundPattern> _createBoundPatterns(@Nonnull XPath xPath, @Nonnull ICommonsMap<String, PSXPathBoundDiagnostic> iCommonsMap, @Nonnull PSXPathVariables pSXPathVariables) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = false;
        for (PSPattern pSPattern : this.getAllRelevantPatterns()) {
            Object object;
            Object object2;
            Object object32;
            PSXPathVariables pSXPathVariables2 = new PSXPathVariables();
            if (pSPattern.hasAnyLet()) {
                for (Object object32 : pSPattern.getAllLetsAsMap().entrySet()) {
                    Object object4 = (String)object32.getKey();
                    object2 = (String)object32.getValue();
                    try {
                        object = PSXPathBoundSchema._compileXPath(xPath, (String)object2);
                        pSXPathVariables2.add((String)object4, (XPathExpression)object);
                        if (!pSXPathVariables.contains((String)object4)) continue;
                        this.error(pSPattern, "Duplicate <let> with name '" + (String)object4 + "' in <pattern>");
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.error(pSPattern, "Failed to compile XPath expression '" + (String)object2 + "' in <let> with name '" + (String)object4 + "'", xPathExpressionException);
                    }
                }
            }
            CommonsArrayList commonsArrayList2 = new CommonsArrayList();
            for (Object object4 : pSPattern.getAllRules()) {
                XPathExpression xPathExpression;
                Object object5;
                Object object62;
                Object object72;
                object2 = new PSXPathVariables();
                if (((PSRule)object4).hasAnyLet()) {
                    for (Object object72 : ((PSRule)object4).getAllLetsAsMap().entrySet()) {
                        object62 = (String)object72.getKey();
                        object5 = (String)object72.getValue();
                        try {
                            xPathExpression = PSXPathBoundSchema._compileXPath(xPath, (String)object5);
                            ((PSXPathVariables)object2).add((String)object62, xPathExpression);
                            if (!pSXPathVariables.contains((String)object62) && !pSXPathVariables2.contains((String)object62)) continue;
                            this.error((IPSElement)object4, "Duplicate <let> with name '" + (String)object62 + "' in <rule>");
                        }
                        catch (XPathExpressionException xPathExpressionException) {
                            this.error(pSPattern, "Failed to compile XPath expression '" + (String)object5 + "' in <let> with name '" + (String)object62 + "'", xPathExpressionException);
                        }
                    }
                }
                object = new CommonsArrayList();
                for (Object object62 : ((PSRule)object4).getAllAssertReports()) {
                    object5 = ((PSAssertReport)object62).getTest();
                    try {
                        xPathExpression = PSXPathBoundSchema._compileXPath(xPath, (String)object5);
                        ICommonsList<PSXPathBoundElement> iCommonsList = this._createBoundElements((IPSHasMixedContent)object62, xPath);
                        if (iCommonsList == null) {
                            bl = true;
                            continue;
                        }
                        PSXPathBoundAssertReport pSXPathBoundAssertReport = new PSXPathBoundAssertReport((PSAssertReport)object62, (String)object5, xPathExpression, iCommonsList, iCommonsMap);
                        object.add((Object)pSXPathBoundAssertReport);
                    }
                    catch (Exception exception) {
                        this.error((IPSElement)object62, "Failed to compile XPath expression in <" + (((PSAssertReport)object62).isAssert() ? "assert" : "report") + ">: '" + (String)object5 + "' with the following variables: " + ((PSXPathVariables)object2).getAll(), exception);
                        bl = true;
                    }
                }
                object72 = this.getValidationContext(((PSRule)object4).getContext());
                object62 = null;
                try {
                    object5 = PSXPathBoundSchema._compileXPath(xPath, (String)object72);
                    object62 = new PSXPathBoundRule((PSRule)object4, (String)object72, (XPathExpression)object5, (ICommonsList<PSXPathBoundAssertReport>)object, (PSXPathVariables)object2);
                    commonsArrayList2.add(object62);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error((IPSElement)object4, "Failed to compile XPath expression in <rule>: '" + (String)object72 + "'", xPathExpressionException);
                    bl = true;
                }
            }
            object32 = new PSXPathBoundPattern(pSPattern, (ICommonsList<PSXPathBoundRule>)commonsArrayList2, pSXPathVariables2);
            commonsArrayList.add(object32);
        }
        if (bl) {
            return null;
        }
        return commonsArrayList;
    }

    public PSXPathBoundSchema(@Nonnull IPSQueryBinding iPSQueryBinding, @Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable IPSValidationHandler iPSValidationHandler, @Nullable IXPathConfig iXPathConfig) throws SchematronBindException {
        super(iPSQueryBinding, pSSchema, string, iPSErrorHandler, iPSValidationHandler);
        if (iXPathConfig != null) {
            this.m_aXPathConfig = iXPathConfig;
        } else {
            try {
                this.m_aXPathConfig = new XPathConfigBuilder().build();
            }
            catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
                throw new SchematronBindException("Failed to create XPath configuration", xPathFactoryConfigurationException);
            }
        }
        this.m_aXPathVariableResolver = new XPathLetVariableResolver(this.m_aXPathConfig.getXPathVariableResolver());
    }

    @Nonnull
    private XPath _createXPathContext() {
        MapBasedNamespaceContext mapBasedNamespaceContext = this.getNamespaceContext();
        XPath xPath = XPathHelper.createNewXPath((XPathFactory)this.m_aXPathConfig.getXPathFactory(), (XPathVariableResolver)this.m_aXPathVariableResolver, (XPathFunctionResolver)this.m_aXPathConfig.getXPathFunctionResolver(), (NamespaceContext)mapBasedNamespaceContext);
        if ("net.sf.saxon.xpath.XPathEvaluator".equals(xPath.getClass().getName())) {
            XPathEvaluator xPathEvaluator = (XPathEvaluator)xPath;
            xPathEvaluator.setNamespaceContext((NamespaceContext)new SaxonNamespaceContext(mapBasedNamespaceContext));
            Function<Configuration, ErrorReporter> function = configuration -> {
                IPSErrorHandler iPSErrorHandler = this.getErrorHandler();
                return xmlProcessingError -> iPSErrorHandler.handleError((IError)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builder().errorLevel((IErrorLevel)(xmlProcessingError.isWarning() ? EErrorLevel.WARN : EErrorLevel.ERROR))).errorID(xmlProcessingError.getErrorCode() != null ? xmlProcessingError.getErrorCode().toString() : null)).errorLocation((ILocation)SimpleLocation.create((SourceLocator)xmlProcessingError.getLocation()))).errorText(xmlProcessingError.getMessage())).linkedException(xmlProcessingError.getCause())).build());
            };
            xPathEvaluator.getConfiguration().setErrorReporterFactory(function);
        }
        return xPath;
    }

    @Nonnull
    public PSXPathBoundSchema bind() throws SchematronBindException {
        XPathExpression xPathExpression;
        String string;
        String string2;
        Map.Entry entry;
        Iterator iterator;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Binding pure Schematron");
        }
        if (this.m_aBoundPatterns != null) {
            throw new IllegalStateException("bind must only be called once!");
        }
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        XPath xPath = this._createXPathContext();
        this.m_aSchemaVariables = new PSXPathVariables();
        if (pSSchema.hasAnyLet()) {
            iterator = pSSchema.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                string2 = (String)entry.getKey();
                string = (String)entry.getValue();
                try {
                    xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                    if (!this.m_aSchemaVariables.add(string2, xPathExpression).isUnchanged()) continue;
                    this.error(pSSchema, "Duplicate <let> with name '" + string2 + "' in global <schema>");
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSSchema, "Failed to compile XPath expression '" + string + "' in <let> with name '" + string2 + "'", xPathExpressionException);
                }
            }
        }
        if (pSPhase != null) {
            iterator = pSPhase.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                string2 = (String)entry.getKey();
                string = (String)entry.getValue();
                try {
                    xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                    if (!this.m_aSchemaVariables.add(string2, xPathExpression).isUnchanged()) continue;
                    this.error(pSSchema, "Duplicate <let> with name '" + string2 + "' in <phase> with name '" + this.getPhaseID() + "'");
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSSchema, "Failed to compile XPath expression '" + string + "' in <let> with name '" + string2 + "'", xPathExpressionException);
                }
            }
        }
        if ((iterator = this._createBoundDiagnostics(xPath)) == null) {
            throw new SchematronBindException("Failed to precompile the diagnostics of the supplied schema. Check the " + (this.isDefaultErrorHandler() ? "log output" : "error listener") + " for XPath errors!");
        }
        this.m_aBoundPatterns = this._createBoundPatterns(xPath, (ICommonsMap<String, PSXPathBoundDiagnostic>)iterator, this.m_aSchemaVariables);
        if (this.m_aBoundPatterns == null) {
            throw new SchematronBindException("Failed to precompile the supplied schema.");
        }
        return this;
    }

    @Nonnull
    public final IXPathConfig getXPathConfig() {
        return this.m_aXPathConfig;
    }

    @Override
    @Nonnull
    public String getValidationContext(@Nonnull String string) {
        if (string.startsWith("/")) {
            return string;
        }
        return "//" + string;
    }

    private void _evaluateVariables(@Nonnull PSXPathVariables pSXPathVariables, @Nonnull Node node, @Nullable String string, @Nonnull IPSElement iPSElement) {
        for (Map.Entry entry : pSXPathVariables.getAll().entrySet()) {
            Object object;
            String string2 = (String)entry.getKey();
            XPathExpression xPathExpression = (XPathExpression)entry.getValue();
            try {
                object = XPathEvaluationHelper.evaluateWithTypeAutodetect(xPathExpression, node, string);
            }
            catch (XPathExpressionException xPathExpressionException) {
                object = null;
            }
            if (object == null) {
                try {
                    object = XPathEvaluationHelper.evaluateAsNodeList(xPathExpression, node, string);
                    ++this.m_nVarForNodeLists;
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
            }
            if (object == null) {
                try {
                    Double d = XPathEvaluationHelper.evaluateAsNumber(xPathExpression, node, string);
                    if (d != null && !d.isNaN()) {
                        object = d;
                        ++this.m_nVarForNumber;
                    }
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
            }
            if (object == null) {
                try {
                    object = XPathEvaluationHelper.evaluateAsBooleanObj(xPathExpression, node, string);
                    ++this.m_nVarForBoolean;
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
            }
            if (object == null) {
                try {
                    object = XPathEvaluationHelper.evaluateAsString(xPathExpression, node, string);
                    ++this.m_nVarForString;
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
            }
            if (object == null) {
                try {
                    object = XPathEvaluationHelper.evaluateAsNode(xPathExpression, node, string);
                    ++this.m_nVarForNode;
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
            }
            if (object == null) {
                this.error(iPSElement, "Failed to evaluate XPath expression '" + xPathExpression + "' for variable '" + string2 + "'");
                continue;
            }
            this.m_aXPathVariableResolver.setVariableValue(new QName(string2), object);
        }
    }

    private void _removeAllVariables(@Nonnull PSXPathVariables pSXPathVariables) {
        for (String string : pSXPathVariables.getAllNames()) {
            this.m_aXPathVariableResolver.removeVariable(new QName(string));
        }
    }

    private void _validateSerial(@Nonnull Node node, @Nullable String string, @Nonnull IPSValidationHandler iPSValidationHandler) throws SchematronValidationException {
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        iPSValidationHandler.onStart(pSSchema, pSPhase, string);
        this._evaluateVariables(this.m_aSchemaVariables, node, string, pSSchema);
        for (PSXPathBoundPattern pSXPathBoundPattern : this.m_aBoundPatterns) {
            PSPattern pSPattern = pSXPathBoundPattern.getPattern();
            iPSValidationHandler.onPattern(pSPattern);
            this._evaluateVariables(pSXPathBoundPattern.getVariables(), node, string, pSPattern);
            for (PSXPathBoundRule pSXPathBoundRule : pSXPathBoundPattern.getAllBoundRules()) {
                NodeList nodeList;
                PSRule pSRule = pSXPathBoundRule.getRule();
                try {
                    nodeList = XPathEvaluationHelper.evaluateAsNodeList(pSXPathBoundRule.getBoundRuleContext(), node, string);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to evaluate XPath expression to a nodeset: '" + pSXPathBoundRule.getRuleContext() + "'", xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException);
                    continue;
                }
                iPSValidationHandler.onRuleStart(pSRule, nodeList);
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    iPSValidationHandler.onFiredRule(pSRule, pSXPathBoundRule.getRuleContext(), i, n);
                    Node node2 = nodeList.item(i);
                    this._evaluateVariables(pSXPathBoundRule.getVariables(), node2, string, pSRule);
                    for (PSXPathBoundAssertReport pSXPathBoundAssertReport : pSXPathBoundRule.getAllBoundAssertReports()) {
                        PSAssertReport pSAssertReport = pSXPathBoundAssertReport.getAssertReport();
                        boolean bl = pSAssertReport.isAssert();
                        XPathExpression xPathExpression = pSXPathBoundAssertReport.getBoundTestExpression();
                        try {
                            boolean bl2 = XPathEvaluationHelper.evaluateAsBoolean(xPathExpression, node2, string);
                            if (!(bl ? !bl2 && iPSValidationHandler.onFailedAssert(pSXPathBoundRule.getRule(), pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport, null).isBreak() : bl2 && iPSValidationHandler.onSuccessfulReport(pSXPathBoundRule.getRule(), pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport, null).isBreak())) continue;
                            return;
                        }
                        catch (XPathExpressionException xPathExpressionException) {
                            if (!(bl ? iPSValidationHandler.onFailedAssert(pSXPathBoundRule.getRule(), pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport, xPathExpressionException).isBreak() : iPSValidationHandler.onSuccessfulReport(pSXPathBoundRule.getRule(), pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport, xPathExpressionException).isBreak())) continue;
                            return;
                        }
                    }
                }
                this._removeAllVariables(pSXPathBoundRule.getVariables());
            }
            this._removeAllVariables(pSXPathBoundPattern.getVariables());
        }
        this._removeAllVariables(this.m_aSchemaVariables);
        iPSValidationHandler.onEnd(pSSchema, pSPhase);
        if (this.m_nVarForNodeLists > 0 || this.m_nVarForString > 0 || this.m_nVarForNode > 0 || this.m_nVarForBoolean > 0 || this.m_nVarForNumber > 0) {
            SchematronDebug.getDebugLogger().info(() -> "Variables result types: NodeList=" + this.m_nVarForNodeLists + "; String=" + this.m_nVarForString + "; Node=" + this.m_nVarForNode + "; Boolean=" + this.m_nVarForBoolean + "; Number=" + this.m_nVarForNumber);
        }
    }

    @Override
    public void validate(@Nonnull Node node, @Nullable String string, @Nonnull IPSValidationHandler iPSValidationHandler) throws SchematronValidationException {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)iPSValidationHandler, (String)"ValidationHandler");
        if (this.m_aBoundPatterns == null) {
            throw new IllegalStateException("bind was never called!");
        }
        this._validateSerial(node, string, iPSValidationHandler);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("BoundPatterns", this.m_aBoundPatterns).append("SchemaVariables", (Object)this.m_aSchemaVariables).getToString();
    }
}

