/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSParam;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSTitle;
import com.helger.xml.CXMLRegEx;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSPattern
implements IPSElement,
IPSHasID,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup {
    private boolean m_bAbstract = false;
    private String m_sID;
    private String m_sIsA;
    private PSRichGroup m_aRich;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <pattern> does not have an 'id'");
            return false;
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sIsA)) {
            iPSErrorHandler.error(this, "abstract <pattern> may not have an 'is-a'");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sIsA)) {
            for (Object e : this.m_aContent) {
                if (!(e instanceof PSParam)) continue;
                iPSErrorHandler.error(this, "<pattern> without 'is-a' may not contain <param>s");
                return false;
            }
        } else {
            for (Object e : this.m_aContent) {
                if (e instanceof PSRule) {
                    iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <rule>s");
                    return false;
                }
                if (!(e instanceof PSLet)) continue;
                iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <let>s");
                return false;
            }
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_bAbstract && StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "abstract <pattern> does not have an 'id'");
        }
        if (StringHelper.hasText((String)this.m_sID) && !CXMLRegEx.PATTERN_NCNAME.matcher(this.m_sID).matches()) {
            iPSErrorHandler.error(this, "The <pattern> attribute 'id' is not a valid XML NCName");
        }
        if (this.m_bAbstract && StringHelper.hasText((String)this.m_sIsA)) {
            iPSErrorHandler.error(this, "abstract <pattern> may not have an 'is-a'");
        }
        if (StringHelper.hasNoText((String)this.m_sIsA)) {
            for (Object e : this.m_aContent) {
                if (!(e instanceof PSParam)) continue;
                iPSErrorHandler.error(this, "<pattern> without 'is-a' may not contain <param>s");
            }
        } else {
            for (Object e : this.m_aContent) {
                if (e instanceof PSRule) {
                    iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <rule>s");
                }
                if (!(e instanceof PSLet)) continue;
                iPSErrorHandler.error(this, "<pattern> with 'is-a' may not contain <let>s");
            }
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        if (this.m_bAbstract) {
            return false;
        }
        if (StringHelper.hasText((String)this.m_sIsA)) {
            return false;
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(IMicroElement.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    public boolean isAbstract() {
        return this.m_bAbstract;
    }

    public void setAbstract(boolean bl) {
        this.m_bAbstract = bl;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Nullable
    public String getIsA() {
        return this.m_sIsA;
    }

    public void setIsA(@Nullable String string) {
        this.m_sIsA = string;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aContent.containsAny(PSInclude.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return this.m_aContent.getAllInstanceOf(PSInclude.class);
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aContent.add((Object)pSInclude);
    }

    @Nullable
    public PSTitle getTitle() {
        return (PSTitle)this.m_aContent.findFirstMapped(PSTitle.class::isInstance, PSTitle.class::cast);
    }

    public boolean hasTitle() {
        return this.m_aContent.containsAny(PSTitle.class::isInstance);
    }

    public void setTitle(@Nullable PSTitle pSTitle) {
        this.m_aContent.removeIf(PSTitle.class::isInstance);
        if (pSTitle != null) {
            int n = -1;
            int n2 = 0;
            for (Object e : this.m_aContent) {
                if (e instanceof PSInclude) {
                    n = n2;
                }
                ++n2;
            }
            if (n < 0) {
                this.m_aContent.add(0, (Object)pSTitle);
            } else {
                this.m_aContent.add(n + 1, (Object)pSTitle);
            }
        }
    }

    @Nullable
    public PSRule getRuleOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (Object e : this.m_aContent) {
                PSRule pSRule;
                if (!(e instanceof PSRule) || !string.equals((pSRule = (PSRule)e).getID())) continue;
                return pSRule;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSRule> getAllRules() {
        return this.m_aContent.getAllInstanceOf(PSRule.class);
    }

    public boolean containsRule(@Nullable PSRule pSRule) {
        return pSRule != null && this.m_aContent.containsAny(object -> object instanceof PSRule && object.equals(pSRule));
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aContent.getCount(PSRule.class::isInstance);
    }

    public void addRule(@Nonnull PSRule pSRule) {
        ValueEnforcer.notNull((Object)pSRule, (String)"Rule");
        this.m_aContent.add((Object)pSRule);
    }

    public void removeRule(@Nonnull Predicate<? super PSRule> predicate) {
        ValueEnforcer.notNull(predicate, (String)"RuleFilter");
        this.m_aContent.removeIf(object -> object instanceof PSRule && predicate.test((PSRule)object));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSParam> getAllParams() {
        return this.m_aContent.getAllInstanceOf(PSParam.class);
    }

    public boolean hasAnyParam() {
        return this.m_aContent.containsAny(PSParam.class::isInstance);
    }

    public void addParam(@Nonnull PSParam pSParam) {
        ValueEnforcer.notNull((Object)pSParam, (String)"Param");
        this.m_aContent.add((Object)pSParam);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllPs() {
        return this.m_aContent.getAllInstanceOf(PSP.class);
    }

    public void addP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull((Object)pSP, (String)"P");
        this.m_aContent.add((Object)pSP);
    }

    @Override
    public boolean hasAnyLet() {
        return this.m_aContent.containsAny(PSLet.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSLet> getAllLets() {
        return this.m_aContent.getAllInstanceOf(PSLet.class);
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull((Object)pSLet, (String)"Let");
        this.m_aContent.add((Object)pSLet);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllLetsAsMap() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Object e : this.m_aContent) {
            if (!(e instanceof PSLet)) continue;
            PSLet pSLet = (PSLet)e;
            commonsLinkedHashMap.put((Object)pSLet.getName(), (Object)pSLet.getValue());
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IPSElement> getAllContentElements() {
        return this.m_aContent.getAllMapped(object -> object instanceof IPSElement && !(object instanceof PSInclude) && !(object instanceof PSTitle), IPSElement.class::cast);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "pattern");
        if (this.m_bAbstract) {
            microElement.setAttribute("abstract", "true");
        }
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("is-a", this.m_sIsA);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild((IMicroNode)((IMicroElement)object).getClone());
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("abstract", this.m_bAbstract).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("is-a", (Object)this.m_sIsA).appendIfNotNull("rich", (Object)this.m_aRich).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

