/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractCollectingPSErrorHandler
extends AbstractPSErrorHandler {
    private final ErrorList m_aErrorList;

    public AbstractCollectingPSErrorHandler(@Nonnull ErrorList errorList, @Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
        this.m_aErrorList = (ErrorList)ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
    }

    @Override
    protected void handleInternally(@Nonnull IError iError) {
        this.m_aErrorList.add((Object)iError);
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getErrorList() {
        return this.m_aErrorList.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllFailures() {
        return this.m_aErrorList.getAllFailures();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllErrors() {
        return this.m_aErrorList.getAllErrors();
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aErrorList.removeAll();
    }

    public boolean isEmpty() {
        return this.m_aErrorList.isEmpty();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ErrorList", (Object)this.m_aErrorList).getToString();
    }
}

