/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractPSErrorHandler
implements IPSErrorHandler {
    private final IPSErrorHandler m_aNestedErrorHandler;

    protected AbstractPSErrorHandler() {
        this(null);
    }

    protected AbstractPSErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        this.m_aNestedErrorHandler = iPSErrorHandler;
    }

    @Nullable
    public IPSErrorHandler getNestedErrorHandler() {
        return this.m_aNestedErrorHandler;
    }

    protected abstract void handleInternally(@Nonnull IError var1);

    public final void handleError(@Nonnull IError iError) {
        this.handleInternally(iError);
        IPSErrorHandler iPSErrorHandler = this.getNestedErrorHandler();
        if (iPSErrorHandler != null) {
            iPSErrorHandler.handleError(iError);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("NestedErrorHandler", (Object)this.m_aNestedErrorHandler).getToString();
    }
}

