/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.ErrorTextProvider;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.IErrorTextProvider;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.log.LogHelper;
import com.helger.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPSErrorHandler
extends AbstractPSErrorHandler {
    public static final IErrorTextProvider DEFAULT_PS = new ErrorTextProvider().addItem(ErrorTextProvider.EField.ERROR_LEVEL, "[$]").addItem(ErrorTextProvider.EField.ERROR_ID, "[$]").addItem(ErrorTextProvider.EField.ERROR_FIELD_NAME, "in [$]").addItem(ErrorTextProvider.EField.ERROR_LOCATION, "@ $").addItem(ErrorTextProvider.EField.ERROR_TEXT, "$").addItem(ErrorTextProvider.EField.ERROR_LINKED_EXCEPTION_CLASS, "($:").addItem(ErrorTextProvider.EField.ERROR_LINKED_EXCEPTION_MESSAGE, "$)").setFieldSeparator(" ");
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingPSErrorHandler.class);
    private IErrorTextProvider m_aETP = DEFAULT_PS;

    public LoggingPSErrorHandler() {
    }

    public LoggingPSErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
    }

    @Nonnull
    public final IErrorTextProvider getErrorTextProvider() {
        return this.m_aETP;
    }

    @Nonnull
    public final LoggingPSErrorHandler setErrorTextProvider(@Nonnull IErrorTextProvider iErrorTextProvider) {
        ValueEnforcer.notNull((Object)iErrorTextProvider, (String)"ErrorTextProvider");
        this.m_aETP = iErrorTextProvider;
        return this;
    }

    @Override
    protected void handleInternally(@Nonnull IError iError) {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)iError.getErrorLevel(), (String)this.m_aETP.getErrorText(iError, Locale.US), (Throwable)iError.getLinkedException());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ErrorTextProvider", (Object)this.m_aETP).getToString();
    }
}

