/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasTexts;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PSEmph
implements IPSClonableElement<PSEmph>,
IPSOptionalElement,
IPSHasTexts {
    private final ICommonsList<String> m_aContent = new CommonsArrayList();

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<emph> has no content");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<emph> has no content");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add((Object)string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Nullable
    public String getAsText() {
        return StringImplode.getImploded(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "emph");
        for (String string : this.m_aContent) {
            microElement.addText((CharSequence)string);
        }
        return microElement;
    }

    @Nonnull
    public PSEmph getClone() {
        PSEmph pSEmph = new PSEmph();
        for (String string : this.m_aContent) {
            pSEmph.addText(string);
        }
        return pSEmph;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).getToString();
    }
}

