/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PSLet
implements IPSClonableElement<PSLet> {
    private String m_sName;
    private String m_sValue;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.isEmpty((String)this.m_sName)) {
            iPSErrorHandler.error(this, "<let> has no 'name'");
            return false;
        }
        if (StringHelper.isEmpty((String)this.m_sValue)) {
            iPSErrorHandler.error(this, "<let> has no 'value'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.isEmpty((String)this.m_sName)) {
            iPSErrorHandler.error(this, "<let> has no 'name'");
        }
        if (StringHelper.isEmpty((String)this.m_sValue)) {
            iPSErrorHandler.error(this, "<let> has no 'value'");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    public void setName(@Nullable String string) {
        this.m_sName = string;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    public void setValue(@Nullable String string) {
        this.m_sValue = string;
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "let");
        microElement.setAttribute("name", this.m_sName);
        microElement.setAttribute("value", this.m_sValue);
        return microElement;
    }

    @Nonnull
    public PSLet getClone() {
        PSLet pSLet = new PSLet();
        pSLet.setName(this.m_sName);
        pSLet.setValue(this.m_sValue);
        return pSLet;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("name", (Object)this.m_sName).appendIfNotNull("value", (Object)this.m_sValue).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PSLet create(@Nullable String string, @Nullable String string2) {
        PSLet pSLet = new PSLet();
        pSLet.setName(string);
        pSLet.setValue(string2);
        return pSLet;
    }
}

