/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSSpan;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PSP
implements IPSElement,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasMixedContent,
IPSHasID {
    private String m_sID;
    private String m_sClass;
    private String m_sIcon;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(IMicroElement.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public void setClazz(@Nullable String string) {
        this.m_sClass = string;
    }

    @Nullable
    public String getClazz() {
        return this.m_sClass;
    }

    public void setIcon(@Nullable String string) {
        this.m_sIcon = string;
    }

    @Nullable
    public String getIcon() {
        return this.m_sIcon;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add((Object)string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(String.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    @Nullable
    public String getText() {
        return StringImplode.getImploded(this.m_aContent);
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull((Object)pSDir, (String)"Dir");
        this.m_aContent.add((Object)pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDir> getAllDirs() {
        return this.m_aContent.getAllInstanceOf(PSDir.class);
    }

    public void addEmph(@Nonnull PSEmph pSEmph) {
        ValueEnforcer.notNull((Object)pSEmph, (String)"Emph");
        this.m_aContent.add((Object)pSEmph);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSEmph> getAllEmphs() {
        return this.m_aContent.getAllInstanceOf(PSEmph.class);
    }

    public void addSpan(@Nonnull PSSpan pSSpan) {
        ValueEnforcer.notNull((Object)pSSpan, (String)"Span");
        this.m_aContent.add((Object)pSSpan);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSSpan> getAllSpans() {
        return this.m_aContent.getAllInstanceOf(PSSpan.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllContentElements() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "p");
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("class", this.m_sClass);
        microElement.setAttribute("icon", this.m_sIcon);
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.addChild((IMicroNode)((IMicroElement)object).getClone());
                continue;
            }
            if (object instanceof String) {
                microElement.addText((CharSequence)((String)object));
                continue;
            }
            microElement.addChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("class", (Object)this.m_sClass).appendIfNotNull("icon", (Object)this.m_sIcon).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

