/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasForeignAttributes;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@NotThreadSafe
public class PSValueOf
implements IPSClonableElement<PSValueOf>,
IPSHasForeignAttributes {
    private String m_sSelect;
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.isEmpty((String)this.m_sSelect)) {
            iPSErrorHandler.error(this, "<value-of> has no 'select'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.isEmpty((String)this.m_sSelect)) {
            iPSErrorHandler.error(this, "<value-of> has no 'select'");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Nullable
    public String getSelect() {
        return this.m_sSelect;
    }

    public void setSelect(@Nullable String string) {
        this.m_sSelect = string;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "value-of");
        microElement.setAttribute("select", this.m_sSelect);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSValueOf getClone() {
        PSValueOf pSValueOf = new PSValueOf();
        pSValueOf.setSelect(this.m_sSelect);
        if (this.hasForeignAttributes()) {
            pSValueOf.addForeignAttributes((Map)this.m_aForeignAttrs);
        }
        return pSValueOf;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("select", (Object)this.m_sSelect).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }

    @Nonnull
    public static PSValueOf ofSelect(@Nullable String string) {
        PSValueOf pSValueOf = new PSValueOf();
        pSValueOf.setSelect(string);
        return pSValueOf;
    }
}

